/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.vctweaker.tweaker;

import com.viesis.viescraft.common.items.crafting.CraftingManagerVC;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeAction;
import minetweaker.api.recipes.IRecipeFunction;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.api.recipes.ShapelessRecipe;
import minetweaker.mc1112.recipes.RecipeConverter;
import minetweaker.mc1112.recipes.ShapedRecipeBasic;
import minetweaker.mc1112.util.MineTweakerHacks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.vctweaker")
public class TweakerIntegration {
    public static void register() {
        MineTweakerAPI.registerClass(TweakerIntegration.class);
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input == null != (ingredient == null)) {
            return false;
        }
        if (ingredient != null) {
            if (input instanceof ItemStack) {
                if (((ItemStack)input).func_190926_b() != (ingredient == null)) {
                    return false;
                }
                if (!ingredient.matches(MineTweakerMC.getIItemStack((ItemStack)((ItemStack)input)))) {
                    return false;
                }
            } else if (input instanceof String && !ingredient.contains((IIngredient)MineTweakerMC.getOreDict((String)((String)input)))) {
                return false;
            }
        }
        return true;
    }

    @ZenGetter(value="all")
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        List recipes = CraftingManagerVC.getInstance().getRecipeList();
        recipes.stream().filter(recipe -> ingredient.matches(MineTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b()))).forEach(recipe -> {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe((IRecipe)recipe);
            results.add(converted);
        });
        return results;
    }

    @ZenMethod
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        List recipes = CraftingManagerVC.getInstance().getRecipeList();
        for (IRecipe recipe : recipes) {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe((IRecipe)recipe);
            results.add(converted);
        }
        return results;
    }

    @ZenMethod
    public static int remove(IIngredient output, @Optional boolean nbtMatch) {
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        List recipes = CraftingManagerVC.getInstance().getRecipeList();
        for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (recipe.func_77571_b().func_190926_b() || !(nbtMatch ? output.matchesExact(MineTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b())) : output.matches(MineTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b())))) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply((IUndoableAction)new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        TweakerIntegration.addShaped(output, ingredients, function, action, false);
    }

    @ZenMethod
    public static void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        TweakerIntegration.addShaped(output, ingredients, function, action, true);
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        ShapelessRecipe recipe = new ShapelessRecipe(output, ingredients, function, action);
        IRecipe irecipe = RecipeConverter.convert((ShapelessRecipe)recipe);
        MineTweakerAPI.apply((IUndoableAction)new ActionAddRecipe(irecipe, (ICraftingRecipe)recipe));
    }

    @ZenMethod
    public static int removeShaped(IIngredient output, IIngredient[][] ingredients) {
        int ingredientsWidth = 0;
        int ingredientsHeight = 0;
        if (ingredients != null) {
            ingredientsHeight = ingredients.length;
            for (int i = 0; i < ingredients.length; ++i) {
                ingredientsWidth = Math.max(ingredientsWidth, ingredients[i].length);
            }
        }
        List recipes = CraftingManagerVC.getInstance().getRecipeList();
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        block1: for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (recipe.func_77571_b().func_190926_b() || !output.matches(MineTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b()))) continue;
            if (ingredients != null) {
                ShapedRecipes srecipe;
                if (recipe instanceof ShapedRecipes) {
                    srecipe = (ShapedRecipes)recipe;
                    if (ingredientsWidth != srecipe.field_77576_b || ingredientsHeight != srecipe.field_77577_c) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            ItemStack recipeIngredient = srecipe.field_77574_d[j * srecipe.field_77576_b + k];
                            IIngredient ingredient = k > row.length ? null : row[k];
                            if (!TweakerIntegration.matches(recipeIngredient, ingredient)) continue block1;
                        }
                    }
                } else if (recipe instanceof ShapedOreRecipe) {
                    srecipe = (ShapedOreRecipe)recipe;
                    int recipeWidth = MineTweakerHacks.getShapedOreRecipeWidth((ShapedOreRecipe)srecipe);
                    int recipeHeight = srecipe.func_77570_a() / recipeWidth;
                    if (ingredientsWidth != recipeWidth || ingredientsHeight != recipeHeight) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient = k > row.length ? null : row[k];
                            Object input = srecipe.getInput()[j * recipeWidth + k];
                            if (!TweakerIntegration.matches(input, ingredient)) continue block1;
                        }
                    }
                } else if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) {
                    continue;
                }
            } else if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply((IUndoableAction)new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @ZenMethod
    public static int removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        List recipes = CraftingManagerVC.getInstance().getRecipeList();
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        block0: for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (recipe.func_77571_b().func_190926_b() || !output.matches(MineTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b()))) continue;
            if (ingredients != null) {
                ShapelessRecipes srecipe;
                if (recipe instanceof ShapelessRecipes) {
                    srecipe = (ShapelessRecipes)recipe;
                    if (ingredients.length > srecipe.func_77570_a() || !wildcard && ingredients.length < srecipe.func_77570_a()) continue;
                    block1: for (int j = 0; j < ingredients.length; ++j) {
                        for (int k = 0; k < srecipe.func_77570_a(); ++k) {
                            if (TweakerIntegration.matches(srecipe.field_77579_b.get(k), ingredients[j])) continue block1;
                        }
                        continue block0;
                    }
                } else if (recipe instanceof ShapelessOreRecipe) {
                    srecipe = (ShapelessOreRecipe)recipe;
                    NonNullList inputs = srecipe.getInput();
                    if (inputs.size() < ingredients.length || !wildcard && inputs.size() > ingredients.length) continue;
                    block3: for (int j = 0; j < ingredients.length; ++j) {
                        for (int k = 0; k < srecipe.func_77570_a(); ++k) {
                            if (TweakerIntegration.matches(inputs.get(k), ingredients[j])) continue block3;
                        }
                        continue block0;
                    }
                }
                if (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe) {
                    continue;
                }
            } else if (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply((IUndoableAction)new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @ZenMethod
    public static IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = MineTweakerMC.getItemStack((IItemStack)contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.func_70299_a(i, iContents[i]);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(inventory, null);
        if (result.func_190926_b()) {
            return null;
        }
        return MineTweakerMC.getIItemStack((ItemStack)result);
    }

    private static void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
        ShapedRecipe recipe = new ShapedRecipe(output, ingredients, function, action, mirrored);
        IRecipe irecipe = RecipeConverter.convert((ShapedRecipe)recipe);
        MineTweakerAPI.apply((IUndoableAction)new ActionAddRecipe(irecipe, (ICraftingRecipe)recipe));
    }

    private static class ActionAddRecipe
    implements IUndoableAction {
        private final IRecipe recipe;
        private final ICraftingRecipe craftingRecipe;

        public ActionAddRecipe(IRecipe recipe, ICraftingRecipe craftingRecipe) {
            this.recipe = recipe;
            this.craftingRecipe = craftingRecipe;
        }

        public void apply() {
            List recipes = CraftingManagerVC.getInstance().getRecipeList();
            recipes.add(this.recipe);
            if (this.recipe instanceof ShapedRecipeBasic) {
                ShapedRecipeBasic shapedRecipeBasic = (ShapedRecipeBasic)this.recipe;
            }
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe, "vc.workbench");
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            List recipes = CraftingManagerVC.getInstance().getRecipeList();
            recipes.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe, "vc.workbench");
        }

        public String describe() {
            return "Adding recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public String describeUndo() {
            return "Removing recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }

    private static class ActionRemoveRecipes
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<IRecipe> removingRecipes;

        public ActionRemoveRecipes(List<IRecipe> recipes, List<Integer> indices) {
            this.removingIndices = indices;
            this.removingRecipes = recipes;
        }

        public void apply() {
            List recipes = CraftingManagerVC.getInstance().getRecipeList();
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                recipes.remove(this.removingIndices.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.removingRecipes.get(i), "vc.workbench");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            List recipes = CraftingManagerVC.getInstance().getRecipeList();
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(recipes.size(), this.removingIndices.get(i));
                recipes.add(index, this.removingRecipes.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.removingRecipes.get(i), "vc.workbench");
            }
        }

        public String describe() {
            return "Removing " + this.removingIndices.size() + " wrappers";
        }

        public String describeUndo() {
            return "Restoring " + this.removingIndices.size() + " wrappers";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

