package se.gory_moon.tallgates.items;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import se.gory_moon.tallgates.blocks.BlockTallGate;

import java.util.HashMap;
import java.util.Map;

import static se.gory_moon.tallgates.lib.ModInfo.MODID;
import static se.gory_moon.tallgates.blocks.BlockRegistry.*;

public class ItemTallGate extends Item implements ItemRegistry.IMultipleItemModelDefinition {

    private static Block[] GATE_BLOCKS = new Block[]{OAK_TALL_GATE, SPRUCE_TALL_GATE, BIRCH_TALL_GATE, JUNGLE_TALL_GATE, DARK_OAK_TALL_GATE, ACACIA_TALL_GATE};

    public ItemTallGate() {
        this.func_77637_a(CreativeTabs.field_78028_d);
        func_77627_a(true);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < GATE_BLOCKS.length; i++)
                items.add(new ItemStack(this, 1, i));
        }
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77960_j() >= GATE_BLOCKS.length)
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        return super.func_77653_i(stack);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= GATE_BLOCKS.length)
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        return "item." + GATE_BLOCKS[stack.func_77960_j()].getRegistryName().func_110623_a();
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        Map<Integer, ResourceLocation> models = new HashMap<>();
        for(int i = 0; i < GATE_BLOCKS.length; i++) {
            models.put(i, new ResourceLocation(MODID, GATE_BLOCKS[i].getRegistryName().func_110623_a()));
        }
        return models;
    }

    public static Block getBlockFromMeta(int meta) {
        if (meta >= 0 && meta < GATE_BLOCKS.length)
            return GATE_BLOCKS[meta];
        else
            return GATE_BLOCKS[0];
    }

    public static int getMetaFromBlock(Block block) {
        for (int i = 0; i < GATE_BLOCKS.length; i++)
            if (block == GATE_BLOCKS[i])
                return i;
        return 0;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        } else {
            IBlockState blockState = worldIn.func_180495_p(pos);
            Block block = blockState.func_177230_c();

            if (!block.func_176200_f(worldIn, pos)) {
                pos = pos.func_177972_a(facing);
            }

            Block gateBlock = getBlockFromMeta(player.func_184586_b(hand).func_77960_j());
            if (player.func_175151_a(pos, facing, player.func_184586_b(hand)) && gateBlock.func_176196_c(worldIn, pos)) {
                placeGate(worldIn, pos, player.func_174811_aO(), gateBlock);
                SoundType soundtype = gateBlock.func_185467_w();
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
                player.func_184586_b(hand).func_190918_g(1);
                return EnumActionResult.SUCCESS;
            } else {
                return EnumActionResult.FAIL;
            }
        }
    }

    public static void placeGate(World worldIn, BlockPos pos, EnumFacing facing, Block door) {
        BlockPos blockpos = pos.func_177984_a();
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos);
        IBlockState iblockstate = door.func_176223_P().func_177226_a(BlockTallGate.field_185512_D, facing).func_177226_a(BlockTallGate.field_176465_b, flag).func_177226_a(BlockTallGate.field_176466_a, flag);
        worldIn.func_180501_a(pos, iblockstate.func_177226_a(BlockTallGate.HALF, BlockTallGate.EnumGateHalf.LOWER), 2);
        worldIn.func_180501_a(blockpos, iblockstate.func_177226_a(BlockTallGate.HALF, BlockTallGate.EnumGateHalf.UPPER), 2);
        worldIn.func_175685_c(pos, door, false);
        worldIn.func_175685_c(blockpos, door, false);
    }
}
