/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.IntegrationRegistry;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.integration.basemetals.BasemetalsIntegration;
import gory_moon.moarsigns.integration.bop.BiomesOPlentyIntegration;
import gory_moon.moarsigns.integration.forestry.ForestryIntegration;
import gory_moon.moarsigns.integration.ic2.IndustrialCraft2Integration;
import gory_moon.moarsigns.integration.tconstruct.TinkersConstructIntegration;
import gory_moon.moarsigns.integration.techreborn.TechRebornIntegration;
import gory_moon.moarsigns.integration.vanilla.MinecraftIntegration;
import gory_moon.moarsigns.util.IntegrationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class IntegrationHandler {
    private static boolean preSetup = true;

    private static void registerSigns(ArrayList<ItemStack> planks, ArrayList<ItemStack> ingots, boolean log) {
        if (log) {
            MoarSigns.logger.info("Starting sign integrations");
        }
        ArrayList<ISignRegistration> signReg = IntegrationRegistry.getSignReg();
        for (ISignRegistration reg : signReg) {
            try {
                reg.registerWoodenSigns(planks);
                reg.registerMetalSigns(ingots);
            }
            catch (IntegrationException e) {
                if (reg.getActivateTag() == null || reg.getIntegrationName() == null || !Loader.isModLoaded((String)reg.getActivateTag()) || !log) continue;
                MoarSigns.logger.error("Failed " + reg.getIntegrationName() + " SignIntegration");
                continue;
            }
            if (reg.getActivateTag() == null || reg.getIntegrationName() == null || !Loader.isModLoaded((String)reg.getActivateTag())) continue;
            SignRegistry.activateTag(reg.getActivateTag());
            if (!log) continue;
            MoarSigns.logger.info("Loaded " + reg.getIntegrationName() + " SignIntegration");
        }
        if (log) {
            MoarSigns.logger.info("Finished " + SignRegistry.getActiveTagsAmount() + " sign integrations with " + SignRegistry.getActivatedSignRegistry().size() + " signs registered");
        }
        SignRegistry.sortRegistry();
    }

    private ArrayList<ItemStack> getOres(ArrayList<String> names) {
        ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
        for (String name : names) {
            ores.addAll(OreDictionary.getOres((String)name));
        }
        return ores;
    }

    public void preSetupSigns() {
        ArrayList<String> names = IntegrationRegistry.getWoodNames();
        ArrayList<ItemStack> planks = this.getOres(names);
        names = IntegrationRegistry.getMetalNames();
        ArrayList<ItemStack> ingots = this.getOres(names);
        IntegrationHandler.registerSigns(planks, ingots, false);
        preSetup = false;
    }

    public void setupSigns() {
        ArrayList<String> names = IntegrationRegistry.getWoodNames();
        ArrayList<ItemStack> planks = this.getOres(names);
        names = IntegrationRegistry.getMetalNames();
        ArrayList<ItemStack> ingots = this.getOres(names);
        IntegrationHandler.registerSigns(planks, ingots, true);
    }

    public static boolean donePreSetup() {
        return !preSetup;
    }

    public static void genModelFile(String type, String mod, String signName) {
        String base = "../src/main/resources/assets/moarsigns/models/item/";
        try {
            Path path1 = Paths.get(base + "mod_template_sign.json", new String[0]);
            String template = new String(Files.readAllBytes(path1), StandardCharsets.UTF_8);
            String s = template.replaceAll("TYPE", type);
            s = s.replaceAll("MOD", mod);
            s = s.replaceAll("SIGN", signName);
            Path path2 = Paths.get(base + "signs/" + mod + "_" + signName + ".json", new String[0]);
            Files.write(path2, s.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        IntegrationRegistry.registerIntegration(MinecraftIntegration.class);
        IntegrationRegistry.registerIntegration(ForestryIntegration.class);
        IntegrationRegistry.registerIntegration(BiomesOPlentyIntegration.class);
        IntegrationRegistry.registerIntegration(IndustrialCraft2Integration.class);
        IntegrationRegistry.registerIntegration(TinkersConstructIntegration.class);
        IntegrationRegistry.registerIntegration(BasemetalsIntegration.class);
        IntegrationRegistry.registerIntegration(TechRebornIntegration.class);
        IntegrationRegistry.registerPlankOreName("plankWood");
        IntegrationRegistry.registerMetalGemOreName("ingotAdamantine", "blockAdamantine");
        IntegrationRegistry.registerMetalGemOreName("ingotAluminum", "blockAluminum");
        IntegrationRegistry.registerMetalGemOreName("ingotAluminumBrass", "blockAluminumBrass");
        IntegrationRegistry.registerMetalGemOreName("ingotAlumite", "blockAlumite");
        IntegrationRegistry.registerMetalGemOreName("ingotArdite", "blockArdite");
        IntegrationRegistry.registerMetalGemOreName("ingotAquarium", "blockAquarium");
        IntegrationRegistry.registerMetalGemOreName("ingotBrass", "blockBrass");
        IntegrationRegistry.registerMetalGemOreName("ingotBronze", "blockBronze");
        IntegrationRegistry.registerMetalGemOreName("ingotCobalt", "blockCobalt");
        IntegrationRegistry.registerMetalGemOreName("ingotColdiron", "blockColdiron");
        IntegrationRegistry.registerMetalGemOreName("ingotCopper", "blockCopper");
        IntegrationRegistry.registerMetalGemOreName("ingotCupronickel", "blockCupronickel");
        IntegrationRegistry.registerMetalGemOreName("ingotElectrum", "blockElectrum");
        IntegrationRegistry.registerMetalGemOreName("ingotEnderium", "blockEnderium");
        IntegrationRegistry.registerMetalGemOreName("ingotFzDarkIron", "blockFzDarkIron");
        IntegrationRegistry.registerMetalGemOreName("ingotInvar", "blockInvar");
        IntegrationRegistry.registerMetalGemOreName("ingotLead", "blockLead");
        IntegrationRegistry.registerMetalGemOreName("ingotLumium", "blockLumium");
        IntegrationRegistry.registerMetalGemOreName("ingotManyullyn", "blockManyullyn");
        IntegrationRegistry.registerMetalGemOreName("ingotMithril", "blockMithril");
        IntegrationRegistry.registerMetalGemOreName("ingotNickel", "blockNickel");
        IntegrationRegistry.registerMetalGemOreName("ingotPlatinum", "blockPlatinum");
        IntegrationRegistry.registerMetalGemOreName("ingotSignalum", "blockSignalum");
        IntegrationRegistry.registerMetalGemOreName("ingotSilver", "blockSilver");
        IntegrationRegistry.registerMetalGemOreName("ingotStarsteel", "blockStarsteel");
        IntegrationRegistry.registerMetalGemOreName("ingotSteel", "blockSteel");
        IntegrationRegistry.registerMetalGemOreName("ingotTin", "blockTin");
        IntegrationRegistry.registerMetalGemOreName("ingotZinc", "blockZinc");
    }
}

