/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.network.ServerMessageHandler;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSignUpdate
implements IMessage {
    public BlockPos pos;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public ITextComponent[] text;

    public MessageSignUpdate() {
    }

    public MessageSignUpdate(BlockPos pos, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, ITextComponent[] text) {
        this.pos = pos;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignUpdate(TileEntityMoarSign tileEntity) {
        this(tileEntity.func_174877_v(), tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.field_145915_a);
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.pos = packetBuf.func_179259_c();
        this.text = new ITextComponent[4];
        for (i = 0; i < 4; ++i) {
            this.rowLocations[i] = packetBuf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.rowSizes[i] = packetBuf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.visibleRows[i] = packetBuf.readBoolean();
        }
        for (i = 0; i < 4; ++i) {
            this.shadowRows[i] = packetBuf.readBoolean();
        }
        this.lockedChanges = packetBuf.readBoolean();
        for (i = 0; i < 4; ++i) {
            try {
                this.text[i] = packetBuf.func_179258_d();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.func_179255_a(this.pos);
        for (i = 0; i < 4; ++i) {
            packetBuf.writeInt(this.rowLocations[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeInt(this.rowSizes[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeBoolean(this.visibleRows[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeBoolean(this.shadowRows[i]);
        }
        packetBuf.writeBoolean(this.lockedChanges);
        for (i = 0; i < 4; ++i) {
            packetBuf.func_179256_a(this.text[i]);
        }
    }

    public static class Handler
    extends ServerMessageHandler<MessageSignUpdate> {
        @Override
        protected void handle(MessageSignUpdate message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_143004_u();
            WorldServer worldserver = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_71093_bK);
            BlockPos pos = message.pos;
            if (worldserver.func_175667_e(pos)) {
                IBlockState iblockstate = worldserver.func_180495_p(pos);
                TileEntity tileentity = worldserver.func_175625_s(pos);
                if (tileentity instanceof TileEntityMoarSign) {
                    TileEntityMoarSign tileentitysign = (TileEntityMoarSign)tileentity;
                    if (!tileentitysign.func_145914_a() || tileentitysign.func_145911_b() != player) {
                        MoarSigns.logger.warn("Player " + player.func_70005_c_() + " just tried to change non-editable sign");
                        return;
                    }
                    tileentitysign.rowLocations = message.rowLocations;
                    tileentitysign.rowSizes = message.rowSizes;
                    tileentitysign.visibleRows = message.visibleRows;
                    tileentitysign.shadowRows = message.shadowRows;
                    tileentitysign.lockedChanges = message.lockedChanges;
                    ITextComponent[] components = message.text;
                    for (int i = 0; i < components.length; ++i) {
                        tileentitysign.field_145915_a[i] = new TextComponentString(components[i].func_150260_c());
                    }
                    tileentitysign.func_70296_d();
                    worldserver.func_184138_a(pos, iblockstate, iblockstate, 3);
                }
            }
        }
    }
}

