/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.items.ItemMoarSign;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessMoarSignRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList<Object> input = new ArrayList();
    private boolean neiNBTDifferent = false;

    public ShapelessMoarSignRecipe(Block result, boolean neiNBTDifferent, Object ... recipe) {
        this(new ItemStack(result), neiNBTDifferent, recipe);
    }

    public ShapelessMoarSignRecipe(Item result, boolean neiNBTDifferent, Object ... recipe) {
        this(new ItemStack(result), neiNBTDifferent, recipe);
    }

    public ShapelessMoarSignRecipe(ItemStack result, boolean neiNBTDifferent, Object[] recipe) {
        this.output = result.func_77946_l();
        this.neiNBTDifferent = neiNBTDifferent;
        for (Object in : recipe) {
            if (in instanceof ShapedMoarSignRecipe.MatchType) {
                this.input.add((Object)((ShapedMoarSignRecipe.MatchType)((Object)in)));
                continue;
            }
            if (in instanceof MaterialInfo) {
                this.input.add((MaterialInfo)in);
                continue;
            }
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public ShapelessMoarSignRecipe(IRecipe recipe, Map<ItemStack, Object> replacements) {
        this.output = recipe.func_77571_b();
        Iterator i$ = (recipe instanceof ShapelessRecipes ? ((ShapelessRecipes)recipe).field_77579_b : ((ShapelessOreRecipe)recipe).getInput()).iterator();
        while (i$.hasNext()) {
            Object ingred;
            Object finalObj = ingred = i$.next();
            for (Map.Entry<ItemStack, Object> replace : replacements.entrySet()) {
                if (!(ingred instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)((ItemStack)ingred), (boolean)false)) continue;
                if (replace.getValue() instanceof String) {
                    finalObj = OreDictionary.getOres((String)String.valueOf(replace.getValue()));
                    break;
                }
                if (!(replace.getValue() instanceof ShapedMoarSignRecipe.MatchType) && !(replace.getValue() instanceof MaterialInfo)) break;
                finalObj = replace.getValue();
                break;
            }
            this.input.add(finalObj);
        }
    }

    public ItemStack func_77572_b(InventoryCrafting p_77572_1_) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ShapedMoarSignRecipe.MatchType || next instanceof MaterialInfo) {
                    if (slot.func_77973_b() instanceof ItemMoarSign) {
                        SignInfo info = ItemMoarSign.getInfo(slot.func_77978_p());
                        if (next instanceof ShapedMoarSignRecipe.MatchType) {
                            switch ((ShapedMoarSignRecipe.MatchType)((Object)next)) {
                                case ALL: {
                                    match = true;
                                    break;
                                }
                                case METAL: {
                                    match = info.isMetal;
                                    break;
                                }
                                case WOOD: {
                                    match = !info.isMetal;
                                }
                            }
                        } else {
                            match = info.material.materialName.equals(((MaterialInfo)next).materialName);
                        }
                    }
                } else if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof ArrayList) {
                    Iterator itr = ((ArrayList)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public ShapelessMoarSignRecipe setNEINBTDifferent(boolean nbtDiff) {
        this.neiNBTDifferent = nbtDiff;
        return this;
    }

    public boolean isNeiNBTDifferent() {
        return this.neiNBTDifferent;
    }
}

