/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoarSign
extends BlockContainer {
    public boolean isFreestanding;

    protected BlockMoarSign(Material material, boolean freeStand) {
        super(material);
        this.setBlockName("moarsign.sign");
        this.isFreestanding = freeStand;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        Boolean s = !((TileEntityMoarSign)world.getTileEntity((int)x, (int)y, (int)z)).isMetal;
        return s != false ? Blocks.planks.getIcon(world, x, y, z, side) : Blocks.iron_block.getIcon(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return Blocks.planks.getIcon(par1, par2);
    }

    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        SignInfo signInfo = this.getSignInfo(world, x, y, z);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(world, x, y, z, random);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        SignInfo signInfo = this.getSignInfo(world, x, y, z);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, x, y, z, entity);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        SignInfo signInfo = this.getSignInfo(world, x, y, z);
        if (signInfo != null && signInfo.property != null) {
            return signInfo.property.onRightClick(world, x, y, z, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        if (!this.isFreestanding) {
            boolean flatSign;
            int l = world.getBlockMetadata(x, y, z);
            float f = 0.28125f;
            float f1 = 0.78125f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 0.125f;
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            int side = l & 7;
            boolean bl = flatSign = (l & 8) >> 3 == 1;
            if (flatSign) {
                boolean groundSign;
                boolean bl2 = groundSign = (l & 1) == 1;
                if (groundSign) {
                    int rotation = (l & 6) >> 1;
                    this.setBlockBounds(f2, f2, f - 0.01f, f3, f4, f1 - 0.01f);
                    if (rotation == 1) {
                        this.setBlockBounds(f - 0.05f, f2, f2, f1 - 0.05f, f4, f3);
                    } else if (rotation == 2) {
                        this.setBlockBounds(f2, f2, f - 0.05f, f3, f4, f1 - 0.05f);
                    } else if (rotation == 3) {
                        this.setBlockBounds(f - 0.01f, f2, f2, f1 - 0.01f, f4, f3);
                    }
                } else {
                    int rotation = (l & 6) >> 1;
                    this.setBlockBounds(f2, f3 - f4, f - 0.05f, f3, f3, f1 - 0.05f);
                    if (rotation == 1) {
                        this.setBlockBounds(f - 0.01f, f3 - f4, f2, f1 - 0.01f, f3, f3);
                    } else if (rotation == 2) {
                        this.setBlockBounds(f2, f3 - f4, f - 0.01f, f3, f3, f1 - 0.01f);
                    } else if (rotation == 3) {
                        this.setBlockBounds(f - 0.05f, f3 - f4, f2, f1 - 0.05f, f3, f3);
                    }
                }
            } else if (side == 2) {
                this.setBlockBounds(f2, f - 0.01f, f3 - f4, f3, f1 - 0.01f, f3);
            } else if (side == 3) {
                this.setBlockBounds(f2, f - 0.01f, f2, f3, f1 - 0.01f, f4);
            } else if (side == 4) {
                this.setBlockBounds(f3 - f4, f - 0.01f, f2, f3, f1 - 0.01f, f3);
            } else if (side == 5) {
                this.setBlockBounds(f2, f - 0.01f, f2, f4, f1 - 0.01f, f3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    effectRenderer.addEffect((EntityFX)new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, x, y, z, (Block)this, meta, 3).applyColourMultiplier(x, y, z));
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.blockX;
        int y = target.blockY;
        int z = target.blockZ;
        int side = target.sideHit;
        Block block = worldObj.getBlock(x, y, z);
        if (block != null) {
            float f = 0.1f;
            double d0 = (double)x + worldObj.rand.nextDouble() * (block.getBlockBoundsMaxX() - block.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + block.getBlockBoundsMinX();
            double d1 = (double)y + worldObj.rand.nextDouble() * (block.getBlockBoundsMaxY() - block.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + block.getBlockBoundsMinY();
            double d2 = (double)z + worldObj.rand.nextDouble() * (block.getBlockBoundsMaxZ() - block.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + block.getBlockBoundsMinZ();
            if (side == 0) {
                d1 = (double)y + block.getBlockBoundsMinY() - (double)f;
            }
            if (side == 1) {
                d1 = (double)y + block.getBlockBoundsMaxY() + (double)f;
            }
            if (side == 2) {
                d2 = (double)z + block.getBlockBoundsMinZ() - (double)f;
            }
            if (side == 3) {
                d2 = (double)z + block.getBlockBoundsMaxZ() + (double)f;
            }
            if (side == 4) {
                d0 = (double)x + block.getBlockBoundsMinX() - (double)f;
            }
            if (side == 5) {
                d0 = (double)x + block.getBlockBoundsMaxX() + (double)f;
            }
            effectRenderer.addEffect(new EntityDiggingFXMoarSigns(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, x, y, z, block, worldObj.getBlockMetadata(x, y, z), side).applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
        }
        return true;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        boolean flag = false;
        if (this.isFreestanding) {
            if (!world.getBlock(x, y - 1, z).getMaterial().isSolid()) {
                flag = true;
            }
        } else {
            boolean flatSign;
            int i = world.getBlockMetadata(x, y, z);
            int i1 = i & 7;
            boolean bl = flatSign = (i & 8) >> 3 == 1;
            if (flatSign) {
                boolean groundSign;
                boolean bl2 = groundSign = (i & 1) == 1;
                flag = groundSign ? !world.getBlock(x, y - 1, z).getMaterial().isSolid() : !world.getBlock(x, y + 1, z).getMaterial().isSolid();
            } else {
                boolean bl3 = flag = i1 != 2 || !world.getBlock(x, y, z + 1).getMaterial().isSolid();
                if (i1 == 2 && world.getBlock(x, y, z + 1).getMaterial().isSolid()) {
                    flag = false;
                }
                if (i1 == 3 && world.getBlock(x, y, z - 1).getMaterial().isSolid()) {
                    flag = false;
                }
                if (i1 == 4 && world.getBlock(x + 1, y, z).getMaterial().isSolid()) {
                    flag = false;
                }
                if (i1 == 5 && world.getBlock(x - 1, y, z).getMaterial().isSolid()) {
                    flag = false;
                }
            }
        }
        if (flag) {
            world.setBlockToAir(x, y, z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign)world.getTileEntity(x, y, z);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.sign.createMoarItemStack(s, tileEntity.isMetal);
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        this.dropBlockAsItem(world, x, y, z, oldMeta, 0);
        super.breakBlock(world, x, y, z, oldBlock, oldMeta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.getTileEntity(x, y, z);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null) {
                return ret;
            }
            ret.add(ModItems.sign.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity entity = world.getTileEntity(x, y, z);
        if (entity instanceof TileEntityMoarSign) {
            ((TileEntityMoarSign)entity).removeNoDrop = player.capabilities.isCreativeMode;
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z, int meta) {
        boolean flatSign = (meta & 8) >> 3 == 1;
        int side = flatSign ? meta & 1 : meta & 7;
        switch (side) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return !super.canPlaceBlockAt(world, x, y, z) && world.getBlock(x, y, z).getMaterial().isSolid();
    }

    public SignInfo getSignInfo(World world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            return SignRegistry.get(sign.texture_name);
        }
        return null;
    }
}

