/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import gory_moon.moarsigns.ConfigHandler;
import gory_moon.moarsigns.SignInitialization;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.ClientEventHandler;
import gory_moon.moarsigns.client.interfaces.GuiHandler;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="MoarSigns", name="MoarSigns", version="1.1.4")
public class MoarSigns {
    private static final String LINK = "https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version.json";
    @Mod.Instance(value="MoarSigns")
    public static MoarSigns instance;
    @SidedProxy(clientSide="gory_moon.moarsigns.proxy.ClientProxy", serverSide="gory_moon.moarsigns.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static HashMap<String, IIcon> icons;
    private static HashMap<String, ResourceLocation> textures;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new ConfigHandler(event.getSuggestedConfigurationFile());
        FMLInterModComms.sendRuntimeMessage((Object)"MoarSigns", (String)"VersionChecker", (String)"addVersionCheck", (String)LINK);
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        Blocks.init();
        ModItems.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initRenderers();
        this.setupSigns();
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ModItems.registerRecipes();
    }

    public ResourceLocation getResourceLocation(String s, boolean isMetal) {
        ResourceLocation location = textures.get(s);
        if (location == null) {
            SignInfo info = SignRegistry.get(s);
            if (info == null) {
                return null;
            }
            location = new ResourceLocation(info.modId.toLowerCase(), "textures/signs/" + (isMetal ? "metal/" : "wood/") + s + ".png");
            textures.put(s, location);
        }
        return location;
    }

    public void setupSigns() {
        ArrayList planks = OreDictionary.getOres((String)"plankWood");
        ArrayList<ItemStack> ingots = new ArrayList<ItemStack>();
        ingots.addAll(OreDictionary.getOres((String)"ingotCopper"));
        ingots.addAll(OreDictionary.getOres((String)"ingotTin"));
        ingots.addAll(OreDictionary.getOres((String)"ingotSilver"));
        ingots.addAll(OreDictionary.getOres((String)"ingotBronze"));
        ingots.addAll(OreDictionary.getOres((String)"ingotSteel"));
        ingots.addAll(OreDictionary.getOres((String)"ingotLead"));
        SignInitialization.addWoodMaterial(planks);
        SignInitialization.addMetalMaterial(ingots);
        Collections.sort(SignRegistry.getActivatedSignRegistry(), new Comparator<SignInfo>(){

            @Override
            public int compare(SignInfo o1, SignInfo o2) {
                return o1.isMetal && !o2.isMetal ? 1 : (o1.isMetal ? 0 : (o2.isMetal ? -1 : (o1.material.path.equals("") && o1.material.path.equals(o2.material.path) ? 0 : (o1.material.path.equals(o2.material.path) ? o1.itemName.compareToIgnoreCase(o2.itemName) : o1.material.path.compareTo(o2.material.path)))));
            }
        });
        Container dummyContainer = new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return false;
            }

            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);
        for (Map.Entry<String, Set<MaterialInfo>> materialList : MaterialRegistry.materialRegistry.entrySet()) {
            for (MaterialInfo material : materialList.getValue()) {
                ItemStack stack = material.material;
                if (stack.func_77973_b() == null || stack.func_77973_b() instanceof ItemBlock) continue;
                for (int i = 0; i < 9; ++i) {
                    crafting.func_70299_a(i, stack);
                }
                ItemStack stack1 = CraftingManager.func_77594_a().func_82787_a(crafting, null);
                if (stack1 != null) {
                    material.material = stack1;
                }
                for (int i = 0; i < 9; ++i) {
                    crafting.func_70299_a(i, null);
                }
            }
        }
    }

    static {
        logger = LogManager.getLogger((String)"MoarSigns");
        icons = new HashMap();
        textures = new HashMap();
    }
}

