/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.field_77777_bU = 16;
        this.func_77637_a(MoarSignsCreativeTab.tabMS);
        this.func_77655_b("moarsign");
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack stack) {
        SignInfo info = SignRegistry.get(this.getTextureFromNBTFull(stack.func_77978_p()));
        if (info == null) {
            return super.func_77658_a() + ".sign.dummy";
        }
        return super.func_77658_a() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + this.getTextureFromNBT(stack.func_77978_p());
    }

    public void func_94581_a(IIconRegister register) {
        List<SignInfo> signRegistry = SignRegistry.getSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            String loc = info.isMetal ? "metal/" : "wood/";
            IIcon icon = register.func_94245_a(info.modId.toLowerCase() + ":" + loc + (path.equals("") ? "" : path.replace("\\", "/")) + info.itemName);
            MoarSigns.icons.put((path.equals("") ? "" : path) + info.itemName, icon);
        }
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        this.getSubItemStacks(list);
    }

    public void getSubItemStacks(List list) {
        List<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            list.add(this.createMoarItemStack(path + info.itemName, info.isMetal));
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        SignInfo info = SignRegistry.get(this.getTextureFromNBTFull(stack.func_77978_p()));
        if (info == null) {
            return MoarSigns.icons.get("oak_sign");
        }
        String path = info.material.path;
        return MoarSigns.icons.get((path.equals("") ? "" : path) + info.itemName);
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("SignTexture", signName.replace("\\", "/"));
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
    }

    public String getTextureFromNBT(NBTTagCompound compound) {
        String texture;
        String string = texture = compound != null && compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityMoarSign tileEntity;
        int rotation;
        if (!world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            return false;
        }
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (!player.func_82247_a(x, y, z, side, stack) || !Blocks.signStandingWood.func_149742_c(world, x, y, z) || world.field_72995_K) {
            return false;
        }
        if (side == 1 && !player.func_70093_af()) {
            rotation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (stack.func_77960_j() == 0) {
                world.func_147465_d(x, y, z, Blocks.signStandingWood, rotation, 3);
            } else if (stack.func_77960_j() == 1) {
                world.func_147465_d(x, y, z, Blocks.signStandingMetal, rotation, 3);
            }
        } else {
            if (side == 0 || side == 1) {
                rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                side += rotation << 1;
                side += 8;
            }
            if (stack.func_77960_j() == 0) {
                world.func_147465_d(x, y, z, Blocks.signWallWood, side, 3);
            } else if (stack.func_77960_j() == 1) {
                world.func_147465_d(x, y, z, Blocks.signWallMetal, side, 3);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if ((tileEntity = (TileEntityMoarSign)world.func_147438_o(x, y, z)) != null) {
            String texture = this.getTextureFromNBTFull(stack.func_77978_p());
            SignInfo info = SignRegistry.get(texture);
            if (info == null) {
                return false;
            }
            tileEntity.setResourceLocation(texture);
            tileEntity.isMetal = info.isMetal;
            tileEntity.func_145912_a(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(tileEntity), (EntityPlayerMP)player);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
    }
}

