/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.tweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.integration.tweaker.MatchTypeEntry;
import gory_moon.moarsigns.integration.tweaker.MaterialEntry;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.moarsigns.Signs")
public class Signs {
    private static List<ItemStack> signs = new ArrayList<ItemStack>();

    @ZenMethod
    public static IItemStack[] getSigns(IIngredient ingredient) {
        IItemStack[] base = new IItemStack[]{};
        if (ingredient instanceof MatchTypeEntry || ingredient instanceof MaterialEntry) {
            if (signs.isEmpty()) {
                ModItems.SIGN.getSubItemStacks(signs);
            }
            ArrayList<MCItemStack> signs = new ArrayList<MCItemStack>();
            if (ingredient instanceof MatchTypeEntry) {
                for (ItemStack stack : Signs.signs) {
                    SignInfo info = ItemMoarSign.getInfo(stack.func_77978_p());
                    if (ingredient.getInternal() == MatchType.ALL) {
                        signs.add(new MCItemStack(stack));
                        continue;
                    }
                    if (ingredient.getInternal() == MatchType.METAL && info.isMetal) {
                        signs.add(new MCItemStack(stack));
                        continue;
                    }
                    if (ingredient.getInternal() != MatchType.WOOD || info.isMetal) continue;
                    signs.add(new MCItemStack(stack));
                }
            } else {
                for (ItemStack stack : Signs.signs) {
                    SignInfo info = ItemMoarSign.getInfo(stack.func_77978_p());
                    if (!((MaterialInfo)ingredient.getInternal()).materialName.equals(info.material.materialName) || ((MaterialEntry)ingredient).getModID() != null && !((MaterialEntry)ingredient).getModID().equals(info.activateTag)) continue;
                    signs.add(new MCItemStack(stack));
                }
            }
            return signs.toArray(base);
        }
        return (IItemStack[])Collections.emptyList().toArray();
    }

    @ZenMethod
    public static IItemStack getFirstSign(IIngredient ingredient) {
        IItemStack[] signs = Signs.getSigns(ingredient);
        if (signs.length > 0) {
            return signs[0];
        }
        return null;
    }

    protected static enum MatchType {
        ALL,
        METAL,
        WOOD;


        public static MatchType getEnum(String match) {
            if ("ALL".equals(match)) {
                return ALL;
            }
            if ("METAL".equals(match)) {
                return METAL;
            }
            if ("WOOD".equals(match)) {
                return WOOD;
            }
            return ALL;
        }
    }
}

