package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

import java.util.ArrayList;
import java.util.HashSet;

public class InventoryExchange implements IInventory {

    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(28, ItemStack.field_190927_a);
    public ContainerExchange container;

    public InventoryExchange() {
        super();
    }

    public void clearInventory() {
        for (int i = 1; i < inventory.size(); i++) {
           func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void update() {
        ItemStack signStack = inventory.get(0);
        clearInventory();

        if (signStack.func_190926_b()) {
            return;
        }

        Item item = signStack.func_77973_b();
        if (item instanceof ItemBlock && !((ItemBlock) item).func_179223_d().equals(Blocks.field_150350_a)) {
            return;
        }

        if (!(item instanceof ItemMoarSign)) {
            return;
        }

        String texture = ((ItemMoarSign) item).getTextureFromNBTFull(signStack.func_77978_p());
        SignInfo signInfo = SignRegistry.get(texture);

        if (signInfo == null)
            return;

        HashSet<MaterialInfo> materials = MaterialRegistry.get(signInfo.material.materialName);
        if (materials == null || materials.size() < 1) {
            return;
        }

        ArrayList<SignInfo> signs = SignRegistry.getSignInfoFromMaterials(materials);

        if (signs.size() < 1) {
            return;
        }

        int i = 0;
        while (i + 1 < 28 && i < signs.size()) {
            SignInfo info = signs.get(i);
            func_70299_a(i + 1, ModItems.SIGN.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
            i++;
        }

        container.onSlotChanged();
    }

    @Override
    public int func_70302_i_() {
        return inventory.size();
    }

    @Override
    public boolean func_191420_l() {
        return inventory.isEmpty();
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return inventory.get(i);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = inventory.get(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() <= amount) {
                func_70299_a(slot, ItemStack.field_190927_a);
                return stack;
            } else {
                stack = stack.func_77979_a(amount);

                if (stack.func_190916_E() == 0) {
                    func_70299_a(slot, ItemStack.field_190927_a);
                }

                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        ItemStack stack = func_70301_a(slot);

        func_70299_a(slot, ItemStack.field_190927_a);
        inventory.set(slot, ItemStack.field_190927_a);

        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        inventory.set(slot, stack);
    }

    @Override
    public String func_70005_c_() {
        return "Exchange Inventory";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public int func_70297_j_() {
        return 16;
    }

    @Override
    public void func_70296_d() {
        // Ignoring method
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        ItemStack held = player.field_71071_by.func_70301_a(container.toolBoxSlot);
        return !held.func_190926_b() && held.func_77973_b() instanceof ItemSignToolbox;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        // Ignoring opening the inventory
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        // Ignoring closing the inventory
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return !(!stack.func_190926_b() && (stack.func_77973_b() instanceof ItemSignToolbox)) && i == inventory.size() && !stack.func_190926_b()&& stack.func_77973_b() instanceof ItemMoarSign;
    }

    @Override
    public int func_174887_a_(int id) {
        return id;
    }

    @Override
    public void func_174885_b(int id, int value) {
        // Ignoring method
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        inventory.clear();
    }


}
