/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api.ingredients;

import gory_moon.moarsigns.items.ModItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class MatchAllIngredient
extends Ingredient {
    public ItemStack[] matchingStacksExploded;
    public IntList matchingStacksPacked;

    protected MatchAllIngredient() {
        super(new ItemStack[]{new ItemStack((Item)ModItems.SIGN, 1, Short.MAX_VALUE)});
    }

    protected MatchAllIngredient(ItemStack stack) {
        super(new ItemStack[]{stack});
    }

    public ItemStack[] getMatchingStacks() {
        if (this.matchingStacksExploded == null || this.matchingStacksExploded.length <= 0) {
            NonNullList lst = NonNullList.create();
            for (ItemStack s : this.matchingStacks) {
                if (s.getMetadata() == Short.MAX_VALUE) {
                    s.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                    continue;
                }
                lst.add((Object)s);
            }
            this.matchingStacksExploded = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
        }
        return this.matchingStacksExploded;
    }

    public IntList getValidItemStacksPacked() {
        if (this.matchingStacksPacked == null) {
            this.getMatchingStacks();
            this.matchingStacksPacked = new IntArrayList(this.matchingStacksExploded.length);
            for (ItemStack itemstack : this.matchingStacksExploded) {
                this.matchingStacksPacked.add(RecipeItemHelper.pack((ItemStack)itemstack));
            }
            this.matchingStacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    protected void invalidate() {
        this.matchingStacksPacked = null;
    }

    public boolean isSimple() {
        return true;
    }
}

