package gory_moon.moarsigns.items;

import cofh.api.item.IToolHammer;
import com.google.common.collect.Lists;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.client.interfaces.GuiHandler;
import gory_moon.moarsigns.lib.Constants;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.RotationHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Collections;
import java.util.List;

import static gory_moon.moarsigns.lib.ToolBoxModes.*;

public class ItemSignToolbox extends VariantItem implements IToolHammer {

    public static final String SIGN_MOVING_TAG = "SignMoving";
    public static final String NBT_UNLOCALIZED_NAME = "SignUnlocalizedName";

    public ItemSignToolbox() {
        setRegistryName(Constants.SIGN_TOOLBOX_ITEM_KEY);
        func_77655_b("moarsigns.signtoolbox");
        func_77637_a(MoarSignsCreativeTab.tabMS);
        func_77627_a(true);
        func_77625_d(1);
    }

    @Override
    public boolean func_77645_m() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            RayTraceResult movingObjectPosition = func_77621_a(world, player, false);
            RayTraceResult.Type hit = movingObjectPosition != null ? movingObjectPosition.field_72313_a : RayTraceResult.Type.MISS;

            if (hit == RayTraceResult.Type.MISS) {
                int mode = isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
                if (player.func_70093_af() && !isMoving(stack.func_77952_i())) {
                    return rotateModes(stack);
                } else if (values()[mode] == EXCHANGE_MODE) {
                    doExchange(world, BlockPos.field_177992_a, player);
                } else if (values()[mode] == PREVIEW_MODE) {
                    doPreview(world, BlockPos.field_177992_a, player);
                }
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            int mode = isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
            switch (values()[mode]) {
                case EDIT_MODE:
                    doEdit(world, pos, player);
                    break;
                case ROTATE_MODE:
                    doRotate(world, pos, player);
                    break;
                case MOVE_MODE:
                    return doMove(world, pos, stack, player, hand, side, hitX, hitY, hitZ);
                case COPY_MODE:
                    doCopy(world, pos, stack, player);
                    break;
                case EXCHANGE_MODE:
                    doExchange(world, pos, player);
                    return EnumActionResult.SUCCESS;
                case PREVIEW_MODE:
                    doPreview(world, pos, player);
                    return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public static void doRotate(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockMoarSign) {
            RotationHandler.rotate((TileEntityMoarSign) world.func_175625_s(pos), player.func_70093_af());
        }
    }

    private void doEdit(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockMoarSign) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileEntity = (TileEntityMoarSign) entity;
                tileEntity.func_145913_a(true);
                tileEntity.func_145912_a(player);
                PacketHandler.INSTANCE.sendTo(new MessageSignOpenGui(tileEntity, false), (EntityPlayerMP) player);
            }
        }
    }

    public void doCopy(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        NBTTagCompound signInfo = stack.func_77978_p();
        if (player.func_70093_af()) {
            TileEntity tileEntity = world.func_175625_s(pos);

            if (tileEntity instanceof TileEntityMoarSign) {
                signInfo = new NBTTagCompound();
                tileEntity.func_189515_b(signInfo);
                signInfo.func_82580_o(TileEntityMoarSign.NBT_TEXTURE_TAG);
                signInfo.func_82580_o(TileEntityMoarSign.NBT_METAL_TAG);
                stack.func_77982_d(signInfo);
            }
        } else if (signInfo != null) {
            TileEntity tileEntity = world.func_175625_s(pos);

            if (tileEntity instanceof TileEntityMoarSign) {
                tileEntity.func_145839_a(signInfo);
                tileEntity.func_174878_a(pos);
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            }
        }
    }

    private EnumActionResult doMove(World world, BlockPos pos, ItemStack stack, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumActionResult val = EnumActionResult.SUCCESS;
        NBTTagCompound signInfo = stack.func_77978_p();

        if (!isMoving(stack.func_77952_i())) {
            TileEntity tileEntity = world.func_175625_s(pos);

            if (tileEntity instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileEntityMoarSign = (TileEntityMoarSign) tileEntity;
                signInfo = new NBTTagCompound();
                tileEntity.func_189515_b(signInfo);
                ItemStack signStack = ModItems.SIGN.createMoarItemStack(tileEntityMoarSign.texture_name, tileEntityMoarSign.isMetal);
                String unlocalizedName = signStack.func_77977_a() + ".name";
                signInfo.func_74778_a(NBT_UNLOCALIZED_NAME, unlocalizedName);

                stack = toggleMoving(stack);
                tileEntityMoarSign.removeNoDrop = true;
                world.func_175698_g(pos);
            }
        } else {
            String texture = signInfo.func_74779_i(TileEntityMoarSign.NBT_TEXTURE_TAG);
            boolean isMetal = signInfo.func_74767_n(TileEntityMoarSign.NBT_METAL_TAG);

            ItemStack moarSignsStack = ModItems.SIGN.createMoarItemStack(texture, isMetal);
            moarSignsStack.func_77978_p().func_74757_a(SIGN_MOVING_TAG, true);
            val = ModItems.SIGN.func_180614_a(moarSignsStack, player, world, pos, hand, side, hitX, hitY, hitZ);

            if (val == EnumActionResult.SUCCESS) {
                pos = pos.func_177972_a(side);

                signInfo.func_82580_o(NBT_UNLOCALIZED_NAME);
                TileEntityMoarSign entityMoarSign = (TileEntityMoarSign) world.func_175625_s(pos);
                entityMoarSign.func_145839_a(signInfo);
                entityMoarSign.func_174878_a(pos);
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);

                signInfo = null;
                stack = toggleMoving(stack);
            }
        }

        stack.func_77982_d(signInfo);
        return val == EnumActionResult.SUCCESS ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
    }

    private void doExchange(World world, BlockPos pos, EntityPlayer player) {
        FMLNetworkHandler.openGui(player, MoarSigns.instance, GuiHandler.EXCHANGE, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private void doPreview(World world, BlockPos pos, EntityPlayer player) {
        FMLNetworkHandler.openGui(player, MoarSigns.instance, GuiHandler.PREVIEW, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private ActionResult<ItemStack> rotateModes(ItemStack stack) {
        int mode = stack.func_77952_i();
        mode = mode + 1 >= 6 ? 0 : mode + 1;
        stack.func_77964_b(mode);
        return ActionResult.newResult(EnumActionResult.SUCCESS, stack);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() > 5 && !isMoving(stack.func_77952_i()))
            stack.func_77964_b(0);
        int mode = isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
        return super.func_77667_c(stack) + "." + values()[mode].toString();
    }

    @SuppressWarnings("unchecked")
    @Override
    @SideOnly(Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        String str = Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.CHANGE.translate(Colors.LIGHTGRAY + "[" + GameSettings.func_74298_c(gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString());

        int mode = isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
        switch (values()[mode]) {
            case COPY_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.COPY.translate(Colors.LIGHTGRAY.toString() + "[" + GameSettings.func_74298_c(gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString(), Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.LIGHTGRAY.toString() + "[");
                if (stack.func_77978_p() != null)
                    str += "\n" + Colors.LIGHTGRAY + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate() + getFormattedData(stack.func_77978_p());
                break;
            case MOVE_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.MOVE.translate(Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.GRAY.toString(), "\n" + Colors.RED.toString());
                if (stack.func_77978_p() != null) {
                    String unlocName = stack.func_77978_p().func_74779_i(NBT_UNLOCALIZED_NAME);
                    if (!unlocName.isEmpty()) {
                        String signName = I18n.func_74838_a(unlocName);
                        str += "\n" + Colors.LIGHTGRAY + Localization.ITEM.SIGNTOOLBOX.CURRENT_SIGN.translate() + " " + Colors.WHITE + signName + "\n" + Colors.LIGHTGRAY + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate() + getFormattedData(stack.func_77978_p());
                    }
                }
                break;
            case EXCHANGE_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.EXCHANGE.translate("\n" + Colors.GRAY.toString());
                break;
            case PREVIEW_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.PREVIEW.translate("\n" + Colors.GRAY.toString());
                break;
            case ROTATE_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.ROTATE.translate(Colors.LIGHTGRAY.toString(), Colors.GRAY.toString(), "\n" + Colors.GRAY, Colors.LIGHTGRAY + "[" + GameSettings.func_74298_c(gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString());
                break;
            case EDIT_MODE:
                str += "\n" + Colors.GRAY + Localization.ITEM.SIGNTOOLBOX.EDIT.translate(Colors.LIGHTGRAY.toString(), Colors.GRAY.toString());
        }

        String[] strList = str.split("\n");
        for (int i = 0; i < strList.length; i++)
            strList[i] = strList[i].trim();
        Collections.addAll(list, strList);
    }

    private String getFormattedData(NBTTagCompound compound) {
        String s = "\n";

        for (int i = 0; i < 4; i++) {
            String text = compound.func_74779_i("Text" + (i + 1));
            ITextComponent component = ITextComponent.Serializer.func_150699_a(text);
            s += Colors.WHITE + "[" + Colors.GRAY + component.func_150254_d() + Colors.WHITE + "]\n";
        }

        return s;
    }

    private boolean isMoving(int itemDamage) {
        return (itemDamage & 7) == 7;
    }

    private ItemStack toggleMoving(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            stack.func_77964_b(7);
        } else if (isMoving(stack.func_77952_i())) {
            stack.func_77964_b(2);
        }
        return stack;
    }

    @Override
    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        return false;
    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {

    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {

    }

    @Override
    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        int mode = isMoving(item.func_77952_i()) ? 2 : item.func_77952_i();
        return values()[mode] == ROTATE_MODE;
    }

    private List<Integer> metas = Lists.newArrayList(0, 1, 2, 3, 4, 5, 7);

    @Override
    public List<Integer> getMetas() {
        return metas;
    }

    @Override
    public String getVariant(int meta) {
        if (meta >= 0 && meta <= 7 && meta != 6)
            return values()[meta == 7 ? 1: meta].toString().toLowerCase().replaceAll("_mode", "");
        return "";
    }
}
