/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client;

import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSignStanding;
import gory_moon.moarsigns.blocks.BlockMoarSignWall;
import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.client.MeshDefinitionFix;
import gory_moon.moarsigns.client.MoarSignsItemMeshDefenition;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.items.NuggetRegistry;
import gory_moon.moarsigns.items.VariantItem;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModModelManager {
    public static final ModModelManager INSTANCE = new ModModelManager();
    private final Set<Item> itemsRegistered = new HashSet<Item>();
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation getModelResourceLocation(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        new IntegrationHandler().preSetupSigns();
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
        SignRegistry.clear();
    }

    private void registerBlockModels() {
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SIGN_STANDING_WOOD, (IStateMapper)new StateMap.Builder().ignore(new IProperty[]{BlockMoarSignStanding.ROTATION}).build());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SIGN_STANDING_METAL, (IStateMapper)new StateMap.Builder().ignore(new IProperty[]{BlockMoarSignStanding.ROTATION}).build());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SIGN_WALL_WOOD, (IStateMapper)new StateMap.Builder().ignore(new IProperty[]{BlockMoarSignWall.ROTATION, BlockMoarSignWall.FACING}).build());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SIGN_WALL_METAL, (IStateMapper)new StateMap.Builder().ignore(new IProperty[]{BlockMoarSignWall.ROTATION, BlockMoarSignWall.FACING}).build());
        ModBlocks.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerItemModels() {
        ArrayList<String> signs = SignRegistry.getTextureLocations(false);
        for (String string : signs) {
            this.registerItemModel((Item)ModItems.SIGN, ModModelManager.getModel(string));
        }
        this.registerItemModel((Item)ModItems.SIGN, new MoarSignsItemMeshDefenition());
        for (Map.Entry entry : Utils.entriesSortedByValues(NuggetRegistry.getNuggets())) {
            this.registerItemModelForMeta((Item)ModItems.NUGGET, ((NuggetRegistry.NuggetInfo)entry.getValue()).id, ModModelManager.getModel("nuggets/" + ((NuggetRegistry.NuggetInfo)entry.getValue()).modId + ((NuggetRegistry.NuggetInfo)entry.getValue()).unlocName));
        }
        this.registerVariantItems(ModItems.SIGN_TOOLBOX, "mode");
        ModItems.RegistrationHandler.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerBlockItemModelForMeta(IBlockState state, int metadata) {
        Item item = Item.getItemFromBlock((Block)state.getBlock());
        if (item != null) {
            this.registerItemModelForMeta(item, metadata, this.propertyStringMapper.getPropertyString((Map)state.getProperties()));
        }
    }

    private <T extends VariantItem> void registerVariantItems(T variant, String variantName) {
        variant.getMetas().forEach(value -> this.registerItemModelForMeta((Item)variant, (int)value, variantName + "=" + variant.getVariant((int)value)));
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private void registerItemModelForMeta(Item item, int metadata, String variant) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }

    public static ModelResourceLocation getModel(String resource) {
        return new ModelResourceLocation("moarsigns:" + resource, "inventory");
    }
}

