package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

import java.util.ArrayList;
import java.util.HashSet;

public class InventoryExchange implements IInventory {

    public ItemStack[] inventory;
    public ContainerExchange container;

    public InventoryExchange() {
        super();

        inventory = new ItemStack[28];
    }

    public void clearInventory() {
        for (int i = 1; i < inventory.length; i++) {
            inventory[i] = null;
        }
    }

    public void update() {
        ItemStack signStack = inventory[0];
        clearInventory();

        if (signStack == null) {
            container.onSlotChanged();
            return;
        }

        Item item = signStack.func_77973_b();
        if (item == null) {
            return;
        }

        if (!(item instanceof ItemMoarSign)) {
            return;
        }

        String texture = ((ItemMoarSign) item).getTextureFromNBTFull(signStack.func_77978_p());
        SignInfo signInfo = SignRegistry.get(texture);

        if (signInfo == null)
            return;

        HashSet<MaterialInfo> materials = MaterialRegistry.get(signInfo.material.materialName);
        if (materials == null || materials.size() < 1) {
            return;
        }

        ArrayList<SignInfo> signs = SignRegistry.getSignInfoFromMaterials(materials);

        if (signs == null || signs.size() < 1) {
            return;
        }
        int i = 0;
        while (i + 1 < 28 && i < signs.size()) {
            SignInfo info = signs.get(i);
            inventory[i + 1] = ModItems.SIGN.createMoarItemStack(info.material.path + info.itemName, info.isMetal);
            i++;
        }

        container.onSlotChanged();
    }

    @Override
    public int func_70302_i_() {
        return inventory.length;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return inventory[i];
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            ItemStack stack;

            if (this.inventory[slot].field_77994_a <= amount) {
                stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            } else {
                stack = this.inventory[slot].func_77979_a(amount);

                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }

                return stack;
            }
        } else {
            return null;
        }
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        ItemStack stack = func_70301_a(slot);

        if (stack == null) {
            return null;
        }
        inventory[slot] = null;

        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        inventory[slot] = stack;
    }

    @Override
    public String func_70005_c_() {
        return "Exchange Inventory";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return (ITextComponent) (this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]));
    }

    @Override
    public int func_70297_j_() {
        return 16;
    }

    @Override
    public void func_70296_d() {
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        // Ignoring opening the inventory
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        // Ignoring closing the inventory
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return !(stack != null && (stack.func_77973_b() instanceof ItemSignToolbox)) && i == inventory.length && stack != null && stack.func_77973_b() instanceof ItemMoarSign;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {

    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        for (int i = 0; i < inventory.length; ++i) {
            inventory[i] = null;
        }
    }


}
