/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.natura;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.api.SignSpecialProperty;
import gory_moon.moarsigns.util.IntegrationException;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class NaturaIntegration
implements ISignRegistration {
    private static final String NATURA_TAG = "natura";
    private static final String PATH = "natura/";
    private Item naturaOver = null;
    private Item naturaNeth = null;

    @Override
    public void registerWoodenSigns(ArrayList<ItemStack> planks) throws IntegrationException {
        for (ItemStack plank : planks) {
            if (plank.getUnlocalizedName().startsWith("tile.natura.overworld_planks") && this.naturaOver == null) {
                this.naturaOver = plank.getItem();
            } else if (plank.getUnlocalizedName().startsWith("tile.natura.nether_planks") && this.naturaNeth == null) {
                this.naturaNeth = plank.getItem();
            }
            if (this.naturaOver == null || this.naturaNeth == null) continue;
            break;
        }
        this.registerWood("maple_sign", null, "maple", new ItemStack(this.naturaOver, 1, 0));
        this.registerWood("silverbell_sign", null, "silverbell", new ItemStack(this.naturaOver, 1, 1));
        this.registerWood("amaranth_sign", null, "amaranth", new ItemStack(this.naturaOver, 1, 2));
        this.registerWood("tigerwood_sign", null, "tigerwood", new ItemStack(this.naturaOver, 1, 3));
        this.registerWood("willow_sign", null, "willow", new ItemStack(this.naturaOver, 1, 4));
        this.registerWood("eucalyptus_sign", null, "eucalyptus", new ItemStack(this.naturaOver, 1, 5));
        this.registerWood("hopseed_sign", null, "hopseed", new ItemStack(this.naturaOver, 1, 6));
        this.registerWood("sakura_sign", null, "sakura", new ItemStack(this.naturaOver, 1, 7));
        this.registerWood("redwood_sign", null, "redwood", new ItemStack(this.naturaOver, 1, 8));
        this.registerWood("ghostwood_sign", null, "ghostwood", new ItemStack(this.naturaNeth, 1, 0));
        this.registerWood("bloodwood_sign", null, "bloodwood", new ItemStack(this.naturaNeth, 1, 1));
        this.registerWood("darkwood_sign", null, "darkwood", new ItemStack(this.naturaNeth, 1, 2));
        this.registerWood("fusewood_sign", null, "fusewood", new ItemStack(this.naturaNeth, 1, 3));
    }

    private void registerWood(String name, SignSpecialProperty property, String materialName, ItemStack material) throws IntegrationException {
        SignRegistry.register(name, property, materialName, PATH, false, material, "moarsigns", NATURA_TAG);
    }

    @Override
    public void registerMetalSigns(ArrayList<ItemStack> metals) throws IntegrationException {
    }

    @Override
    @Nonnull
    public String getActivateTag() {
        return NATURA_TAG;
    }

    @Override
    @Nonnull
    public String getIntegrationName() {
        return Utils.getModName(NATURA_TAG);
    }

    @Override
    public String getModName() {
        return StringUtils.capitalize((String)NATURA_TAG);
    }
}

