/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.horsepower.util.color.ColorThief;

@SideOnly(value=Side.CLIENT)
public final class ColorGetter {
    private ColorGetter() {
    }

    public static List<Color> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (RuntimeException ignored) {
            return Collections.emptyList();
        }
        catch (LinkageError ignored) {
            return Collections.emptyList();
        }
    }

    private static List<Color> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.getItem();
        if (itemStack.isEmpty()) {
            return Collections.emptyList();
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.getBlock();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(itemStack, block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Color> getItemColors(ItemStack itemStack, int colorCount) {
        ItemColors itemColors = Minecraft.getMinecraft().getItemColors();
        int renderColor = itemColors.colorMultiplier(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Color> getBlockColors(ItemStack itemStack, Block block, int colorCount) {
        IBlockState blockState;
        int meta = itemStack.getMetadata();
        try {
            blockState = block.getStateFromMeta(meta);
        }
        catch (RuntimeException ignored) {
            blockState = block.getDefaultState();
        }
        catch (LinkageError ignored) {
            blockState = block.getDefaultState();
        }
        BlockColors blockColors = Minecraft.getMinecraft().getBlockColors();
        int renderColor = blockColors.colorMultiplier(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public static List<Color> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        BufferedImage bufferedImage = ColorGetter.getBufferedImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Color> colors = new ArrayList<Color>(colorCount);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathHelper.clamp((int)red, (int)0, (int)255);
                green = MathHelper.clamp((int)green, (int)0, (int)255);
                blue = MathHelper.clamp((int)blue, (int)0, (int)255);
                Color color = new Color(red, green, blue);
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.getIconWidth();
        int iconHeight = textureAtlasSprite.getIconHeight();
        int frameCount = textureAtlasSprite.getFrameCount();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.getFrameTextureData(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.getMinecraft();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.getBlockRendererDispatcher();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.getBlockModelShapes();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.getTexture(blockState);
        if (textureAtlasSprite == minecraft.getTextureMapBlocks().getMissingSprite()) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.getMinecraft().getRenderItem();
        ItemModelMesher itemModelMesher = renderItem.getItemModelMesher();
        IBakedModel itemModel = itemModelMesher.getItemModel(itemStack);
        return itemModel.getParticleTexture();
    }
}

