package se.gory_moon.horsepower.recipes;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.util.Utils;

public class ComparableItemStack {

    private ItemStack stack;

    public ComparableItemStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ComparableItemStack)) return false;

        ComparableItemStack that = (ComparableItemStack) o;

        return ItemStack.func_77970_a(stack, that.stack) &&
                (that.stack.func_77960_j() == OreDictionary.WILDCARD_VALUE ? stack.func_77973_b() == that.stack.func_77973_b(): stack.func_77969_a(that.stack));
    }

    @Override
    public int hashCode() {
        return Utils.getItemStackHashCode(stack);
    }

    @Override
    public String toString() {
        return stack.toString();
    }
}
