package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.util.Localization;

import javax.annotation.Nullable;

public class TileEntityPress extends TileEntityHPHorseBase {

    private FluidTank tank = new FluidTank(Configs.general.pressFluidTankSize);
    private int currentPressStatus;

    public TileEntityPress() {
        super(2);
        tank.setCanFill(false);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentPressStatus", currentPressStatus);
        compound.func_74782_a("fluid", tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        tank.readFromNBT(compound.func_74775_l("fluid"));

        if (getStackInSlot(0).func_190916_E() > 0) {
            currentPressStatus = compound.func_74762_e("currentPressStatus");
        } else {
            currentPressStatus = 0;
        }
    }

    @Override
    public void func_70296_d() {
        if (getStackInSlot(0).func_190926_b())
            currentPressStatus = 0;

        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if ((x <= 1 && x >= -1) && (z <= 1 && z >= -1))
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f(field_145850_b, pos))
                return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        currentPressStatus++;

        int totalPress = Configs.general.pointsForPress;
        if (currentPressStatus >= (totalPress <= 0 ? 1: totalPress)) {
            currentPressStatus = 0;

            pressItem();
            return true;
        }
        func_70296_d();
        return false;
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getPressRecipe(getStackInSlot(0));
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getPressResult(getStackInSlot(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    private void pressItem() {
        if (canWork()) {
            PressRecipe recipe = (PressRecipe) getRecipe();
            ItemStack result = recipe.getOutput();
            FluidStack fluidResult = recipe.getOutputFluid();

            ItemStack input = getStackInSlot(0);
            ItemStack output = getStackInSlot(1);

            if (recipe.isLiquidRecipe()) {
                tank.fillInternal(fluidResult, true);
                HorsePowerMod.logger.info("Tank: " + tank.getFluid().amount);
            } else {
                if (output.func_190926_b()) {
                    setInventorySlotContents(1, result.func_77946_l());
                } else if (output.func_77969_a(result)) {
                    output.func_190917_f(result.func_190916_E());
                }
            }

            input.func_190918_g(input.func_190916_E());
            func_70296_d();
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = getStackInSlot(index);
        super.setInventorySlotContents(index, stack);

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag)
            currentPressStatus = 0;

        func_70296_d();
    }

    @Override
    public boolean canWork() {
        if (getStackInSlot(0).func_190926_b()) {
            return false;
        } else {
            PressRecipe recipe = (PressRecipe) getRecipe();
            if (recipe == null) return false;

            ItemStack input = recipe.getInput();
            ItemStack itemstack = recipe.getOutput();
            FluidStack fluidOutput = recipe.getOutputFluid();

            if (getStackInSlot(0).func_190916_E() < input.func_190916_E())
                return false;
            if (itemstack.func_190926_b() && !recipe.isLiquidRecipe())
                return false;

            ItemStack output = getStackInSlot(1);
            if (recipe.isLiquidRecipe()) {
                return output.func_190926_b() && (tank.getFluidAmount() == 0 || tank.fillInternal(fluidOutput, false) >= fluidOutput.amount);
            } else {
                return tank.getFluidAmount() == 0 && (output.func_190926_b() || output.func_77969_a(itemstack) && output.func_190916_E() + itemstack.func_190916_E() <= output.func_77976_d());
            }
        }
    }

    @Override
    public int getInventoryStackLimit(ItemStack stack) {
        PressRecipe recipe = HPRecipes.instance().getPressRecipe(stack);
        if (recipe == null)
            return getInventoryStackLimit();
        return recipe.getInput().func_190916_E();
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        return currentPressStatus == 0 ? super.removeStackFromSlot(index): ItemStack.field_190927_a;
    }

    @Override
    public int getInventoryStackLimit() {
        PressRecipe recipe = HPRecipes.instance().getPressRecipe(getStackInSlot(0));
        if (recipe == null)
            return 64;
        return recipe.getInput().func_190916_E();
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasPressRecipe(stack) && currentPressStatus == 0 && getStackInSlot(1).func_190926_b();
    }

    public IFluidTankProperties[] getTankFluidStack() {
        return tank.getTankProperties();
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0:
                return currentPressStatus;
            default:
                return 0;
        }
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0:
                currentPressStatus = value;
                break;
        }
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public String getName() {
        return "container.press";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Nullable
    @Override
    public ITextComponent func_145748_c_() {
        if (valid)
            return super.func_145748_c_();
        else
            return new TextComponentTranslation(Localization.INFO.PRESS_INVALID.key()).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return ((capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == EnumFacing.DOWN)) || super.hasCapability(capability, facing));
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null || facing == EnumFacing.DOWN)
                return (T) tank;
        }
        return super.getCapability(capability, facing);
    }
}
