/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Utils;

public abstract class TileEntityHPHorseBase
extends TileEntityHPBase
implements ITickable {
    protected static double[][] path = new double[][]{{-1.5, -1.5}, {0.0, -1.5}, {1.0, -1.5}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {-1.5, 1.0}, {-1.5, 0.0}};
    protected AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    protected List<BlockPos> searchPos = null;
    protected int origin;
    protected int target = this.origin = -1;
    protected boolean hasWorker = false;
    protected EntityCreature worker;
    protected NBTTagCompound nbtWorker;
    protected boolean valid = false;
    protected int validationTimer = 0;
    protected int locateHorseTimer = 0;
    protected boolean running = true;
    protected boolean wasRunning = false;

    public TileEntityHPHorseBase(int inventorySize) {
        super(inventorySize);
    }

    public abstract boolean validateArea();

    public abstract boolean targetReached();

    public abstract int getPositionOffset();

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.target = compound.func_74762_e("target");
        this.origin = compound.func_74762_e("origin");
        this.hasWorker = compound.func_74767_n("hasWorker");
        if (this.hasWorker && compound.func_150297_b("leash", 10)) {
            this.nbtWorker = compound.func_74775_l("leash");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("origin", this.origin);
        compound.func_74757_a("hasWorker", this.hasWorker);
        if (this.worker != null) {
            if (this.nbtWorker == null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                UUID uuid = this.worker.func_110124_au();
                nbtTagCompound.func_186854_a("UUID", uuid);
                this.nbtWorker = nbtTagCompound;
            }
            compound.func_74782_a("leash", (NBTBase)this.nbtWorker);
        }
        return super.func_189515_b(compound);
    }

    public void setWorker(EntityCreature newWorker) {
        this.hasWorker = true;
        this.worker = newWorker;
        this.worker.func_175449_a(this.field_174879_c, 3);
        this.target = this.getClosestTarget();
        if (this.worker != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = this.worker.func_110124_au();
            nbtTagCompound.func_186854_a("UUID", uuid);
            this.nbtWorker = nbtTagCompound;
        }
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (this.hasWorker() && this.worker.func_184652_a(player)) {
            this.hasWorker = false;
            this.worker.func_110177_bN();
            this.worker.func_110162_b((Entity)player, true);
            this.worker = null;
            this.nbtWorker = null;
        }
    }

    public boolean hasWorker() {
        if (this.worker != null && !this.worker.field_70128_L && !this.worker.func_110167_bD() && this.worker.func_174818_b(this.field_174879_c) < 45.0) {
            return true;
        }
        if (this.worker != null) {
            this.worker = null;
            this.nbtWorker = null;
            if (!this.func_145831_w().field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (ItemStack)new ItemStack(Items.field_151058_ca));
            }
        }
        this.hasWorker = false;
        return false;
    }

    public EntityCreature getWorker() {
        return this.worker;
    }

    public boolean isValid() {
        return this.valid;
    }

    private Vec3d getPathPosition(int i) {
        double x = (double)this.field_174879_c.func_177958_n() + path[i][0] * 2.0;
        double y = this.field_174879_c.func_177956_o() + this.getPositionOffset();
        double z = (double)this.field_174879_c.func_177952_p() + path[i][1] * 2.0;
        return new Vec3d(x, y, z);
    }

    protected int getClosestTarget() {
        if (this.hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;
            for (int i = 0; i < path.length; ++i) {
                Vec3d pos = this.getPathPosition(i);
                double x = pos.field_72450_a;
                double y = pos.field_72448_b;
                double z = pos.field_72449_c;
                double tmp = this.worker.func_70011_f(x, y, z);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closest = i;
            }
            return closest;
        }
        return 0;
    }

    public void func_73660_a() {
        --this.validationTimer;
        if (this.validationTimer <= 0) {
            this.valid = this.validateArea();
            this.validationTimer = this.valid ? 220 : 60;
        }
        boolean flag = false;
        if (!this.hasWorker()) {
            --this.locateHorseTimer;
        }
        if (!this.hasWorker() && this.nbtWorker != null && this.locateHorseTimer <= 0) {
            UUID uuid = this.nbtWorker.func_186857_a("UUID");
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
            block0: for (Class<? extends EntityCreature> clazz : clazzes) {
                for (Object entity : this.field_145850_b.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                    EntityCreature creature;
                    if (!(entity instanceof EntityCreature) || !(creature = (EntityCreature)entity).func_110124_au().equals(uuid)) continue;
                    this.setWorker(creature);
                    flag = true;
                    break block0;
                }
            }
        }
        if (this.locateHorseTimer <= 0) {
            this.locateHorseTimer = 220;
        }
        if (!this.field_145850_b.field_72995_K && this.valid) {
            if (!this.running && this.canWork()) {
                this.running = true;
            } else if (this.running && !this.canWork()) {
                this.running = false;
            }
            if (this.running != this.wasRunning) {
                this.target = this.getClosestTarget();
                this.wasRunning = this.running;
            }
            if (this.hasWorker() && this.running) {
                Vec3d pos = this.getPathPosition(this.target);
                double x = pos.field_72450_a;
                double y = pos.field_72448_b;
                double z = pos.field_72449_c;
                if (this.searchAreas[this.target] == null) {
                    this.searchAreas[this.target] = new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
                }
                if (this.worker.func_174813_aQ().func_72326_a(this.searchAreas[this.target])) {
                    int next = this.target + 1;
                    int previous = this.target - 1;
                    if (next >= path.length) {
                        next = 0;
                    }
                    if (previous < 0) {
                        previous = path.length - 1;
                    }
                    if (this.origin != this.target && this.target != previous) {
                        this.origin = this.target;
                        flag = this.targetReached();
                    }
                    this.target = next;
                }
                if (this.worker instanceof AbstractHorse && ((AbstractHorse)this.worker).func_110204_cc()) {
                    ((AbstractHorse)this.worker).func_110227_p(false);
                }
                if (this.target != -1 && this.worker.func_70661_as().func_75500_f()) {
                    pos = this.getPathPosition(this.target);
                    x = pos.field_72450_a;
                    y = pos.field_72448_b;
                    z = pos.field_72449_c;
                    this.worker.func_70661_as().func_75492_a(x, y, z, 1.0);
                }
            }
        }
        if (flag) {
            this.func_70296_d();
        }
    }
}

