package se.gory_moon.horsepower.jei;

import com.google.common.collect.ImmutableList;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.recipes.ShapedChoppingRecipe;

import java.util.List;

public class ShapedChoppingCraftingWrapper implements IShapedCraftingRecipeWrapper, ICustomCraftingRecipeWrapper {

    private final ShapedChoppingRecipe recipe;
    private final int width;
    private final int height;
    private final List<List<ItemStack>> outputs;

    public ShapedChoppingCraftingWrapper(ShapedChoppingRecipe recipe) {
        this.recipe = recipe;

        for (Object input : this.recipe.func_192400_c()) {
            if (input instanceof ItemStack) {
                ItemStack itemStack = (ItemStack) input;
                if (itemStack.func_190916_E() != 1) {
                    itemStack.func_190920_e(1);
                }
            }
        }
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();

        ImmutableList.Builder<ItemStack> builder = ImmutableList.builder();
        for(ItemStack stack : recipe.outputBlocks) {
            BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(recipe.getSimpleRecipeOutput().func_77973_b());
            if (!Configs.general.useDynamicCrafting && !"minecraft".equals(stack.func_77973_b().getRegistryName().func_110624_b())) {
                builder.add(BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), new ItemStack(Blocks.field_150364_r)));
                break;
            }
            if(stack.func_77952_i() == OreDictionary.WILDCARD_VALUE) {
                for(ItemStack sub : HorsePowerPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
                    builder.add(BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), sub));
                }
            } else if (Block.func_149634_a(stack.func_77973_b()) instanceof BlockHPChoppingBase) {
                NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
                Block.func_149634_a(stack.func_77973_b()).func_149666_a(null, stacks);
                for(ItemStack sub : stacks) {
                    builder.add(BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), sub));
                }
            } else {
                builder.add(BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().func_190916_E(), stack));
            }
        }
        outputs = ImmutableList.of(builder.build());
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = HorsePowerPlugin.jeiHelpers.getStackHelper();

        List<List<ItemStack>> inputs = stackHelper.expandRecipeItemStackInputs(recipe.func_192400_c());
        ingredients.setInputLists(ItemStack.class, inputs);

        if (!outputs.isEmpty())
            ingredients.setOutputLists(ItemStack.class, outputs);
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }

    private boolean isOutputBlock(ItemStack stack) {
        if(stack.func_190926_b()) {
            return false;
        }

        for(ItemStack output : recipe.outputBlocks) {
            // if the item matches the oredict entry, it is an output block
            if(OreDictionary.itemMatches(output, stack, false)) {
                return true;
            }
        }

        return false;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();

        List<List<ItemStack>> inputs = ingredients.getInputs(ItemStack.class);
        List<ItemStack> outputs = ingredients.getOutputs(ItemStack.class).get(0);

        // determine the focused stack
        IFocus<?> ifocus = recipeLayout.getFocus();
        Object focusObj = ifocus.getValue();

        // if the thing in focus is an itemstack
        if(focusObj instanceof ItemStack) {
            IGuiIngredientGroup<ItemStack> guiIngredients = recipeLayout.getIngredientsGroup(ItemStack.class);
            ItemStack focus = (ItemStack)focusObj;
            IFocus.Mode mode = ifocus.getMode();

            // input means we clicked on an ingredient, make sure it is one that affects the base
            if(mode == IFocus.Mode.INPUT && isOutputBlock(focus)) {
                // first, get the output recipe
                BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(recipe.getSimpleRecipeOutput().func_77973_b());

                // then create a stack with the focus item (which we already validated above)
                ItemStack outputFocus = BlockChopper.createItemStack(block, 1, focus);

                // and finally, set the focus override for the recipe
                guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, outputFocus));
            }

            // if we clicked the chopping block, remove all items which affect the base textures that are not the base item
            else if(mode == IFocus.Mode.OUTPUT) {
                // so determine the base
                ItemStack base = new ItemStack(focus.func_77942_o() ? focus.func_77978_p().func_74775_l("textureBlock") : new NBTTagCompound());
                if (Block.func_149634_a(recipe.outputBlocks.get(0).func_77973_b()) instanceof BlockHPChoppingBase) {
                    base = recipe.outputBlocks.get(0).func_77946_l();
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a("textureBlock", focus.func_77942_o() ? focus.func_77978_p().func_74775_l("textureBlock") : new NBTTagCompound());
                    base.func_77982_d(tag);
                }
                if(!base.func_190926_b()) {
                    // and loop through all slots removing leg affecting inputs which don't match
                    guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.INPUT, base));
                }
            }
        }

        // add the itemstacks to the grid
        HorsePowerPlugin.craftingGridHelper.setInputs(guiItemStacks, inputs, this.getWidth(), this.getHeight());
        recipeLayout.getItemStacks().set(0, outputs);
    }
}
