package se.gory_moon.horsepower.blocks;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

@Optional.Interface(iface = "mcjty.theoneprobe.api.IProbeInfoAccessor", modid = "theoneprobe")
public class BlockFiller extends BlockDirectional implements IProbeInfoAccessor {

    private boolean useTileEntity;
    private boolean providePower;

    public BlockFiller(Material materialIn, String name, boolean useTileEntity, boolean providePower) {
        super(materialIn);
        setRegistryName(name + "filler");
        this.useTileEntity = useTileEntity;
        this.providePower = providePower;
    }

    public BlockFiller(Material materialIn, String name, boolean useTileEntity) {
        this(materialIn, name, useTileEntity, false);
    }

    private boolean validateFilled(World world, IBlockState state, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockHPBase) {
            return true;
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            return false;
        }
    }

    public BlockFiller setHarvestLevel1(String tool, int level) {
        setHarvestLevel(tool, level);
        return this;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFiller();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return useTileEntity;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, field_176387_N);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(field_176387_N, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(field_176387_N).func_176745_a();
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        if (!((World) world).field_72995_K && pos.func_177972_a(state.func_177229_b(field_176387_N)).equals(neighbor)) {
            validateFilled((World) world, world.func_180495_p(neighbor), pos);
        }
    }

    @Override
    public void func_176206_d(World world, BlockPos pos0, IBlockState state) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0)) {
            state1.func_177230_c().func_176206_d(world, pos, world.func_180495_p(pos));
            world.func_175655_b(pos, true);
        }
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos0, EntityPlayer player, boolean willHarvest) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            state1.func_177230_c().removedByPlayer(world.func_180495_p(pos), world, pos, player, willHarvest);
        return super.removedByPlayer(state, world, pos0, player, willHarvest);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos0) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (world instanceof World && validateFilled((World) world, state1, pos0))
            return state1.func_177230_c().func_185496_a(state1, world, pos);
        else
            return super.func_185496_a(state, world, pos0);
    }

    @Override
    public boolean func_180639_a(World w, BlockPos p0, IBlockState s, EntityPlayer e, EnumHand h, EnumFacing f, float x, float y, float z) {
        BlockPos p = p0.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        if (validateFilled(w, state1, p0))
            return state1.func_177230_c().func_180639_a(w, p, state1, e, h ,f, x, y, z);
        else
            return super.func_180639_a(w, p, s, e, h, f, x, y, z);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public final AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p0) {
        BlockPos p = p0.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        if (validateFilled(w, state1, p0))
            return state1.func_177230_c().func_180640_a(state1, w, p);
        else
            return super.func_180640_a(s, w, p0);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos0, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            state1.func_177230_c().func_185477_a(state1, world, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    @Override
    public final RayTraceResult func_180636_a(IBlockState s, World w, BlockPos p0, Vec3d start, Vec3d end) {
        BlockPos p = p0.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        if (validateFilled(w, state1, p0)) {
            RayTraceResult trace = state1.func_177230_c().func_180636_a(state1, w, p, start, end);
            return trace != null ? new RayTraceResult(trace.field_72313_a, trace.field_72307_f, trace.field_178784_b, p0) : trace;
        } else
            return super.func_180636_a(s, w, p0, start, end);
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos0, EnumFacing side) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (world instanceof World && validateFilled((World) world, state1, pos0))
            return state1.func_177230_c().shouldCheckWeakPower(state1, world, pos, side);
        else
            return super.shouldCheckWeakPower(state, world, pos0, side);
    }

    @Override
    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos0, EnumFacing side) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (world instanceof World && validateFilled((World) world, state1, pos0))
            return state1.func_177230_c().func_176211_b(state1, world, pos, side);
        else
            return super.func_176211_b(state, world, pos0, side);
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return providePower;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos0, @Nullable EnumFacing side) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (world instanceof World && validateFilled((World) world, state1, pos0))
            return state1.func_177230_c().canConnectRedstone(state1, world, pos, side);
        else
            return super.canConnectRedstone(state, world, pos0, side);
    }

    @Override
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos0, EnumFacing side) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (world instanceof World && validateFilled((World) world, state1, pos0))
            return state1.func_177230_c().func_180656_a(state1, world, pos, side);
        else
            return super.func_180656_a(state, world, pos0, side);
    }

    @Override
    public void func_176199_a(World world, BlockPos pos0, Entity entityIn) {
        BlockPos pos = pos0.func_177972_a(world.func_180495_p(pos0).func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            state1.func_177230_c().func_176199_a(world, pos, entityIn);
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos0, IBlockState state) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            return state1.func_177230_c().func_185473_a(world, pos, state1);
        else
            return super.func_185473_a(world, pos0, state);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos0, EntityPlayer player) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            return state1.func_177230_c().getPickBlock(state1, target, world, pos, player);
        else
            return super.getPickBlock(state, target, world, pos0, player);
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos0, @Nullable Entity entity) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (validateFilled(world, state1, pos0))
            return state1.func_177230_c().getSoundType(state1, world, pos, entity);
        else
            return super.getSoundType(state, world, pos, entity);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a().func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (!validateFilled(world, state1, target.func_178782_a()))
            return true;
        RayTraceResult target1 = new RayTraceResult(target.field_72313_a, target.field_72307_f.func_178786_a(0, 1, 0), target.field_178784_b, pos);
        boolean flag = state1.func_177230_c().addHitEffects(state1, world, target1, manager);
        if (!flag)
            Minecraft.func_71410_x().field_71452_i.func_180532_a(pos, target.field_178784_b);
        return true;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos0, ParticleManager manager) {
        BlockPos pos = pos0.func_177972_a(world.func_180495_p(pos0).func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (!validateFilled(world, state1, pos0))
            return true;
        boolean flag = state1.func_177230_c().addDestroyEffects(world, pos, manager);
        if (!flag)
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, state1);
        return true;
    }

    @Override
    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos0, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        BlockPos pos = pos0.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        if (!validateFilled(world, state1, pos0))
            return true;
        boolean flag = state1.func_177230_c().addLandingEffects(state1, world, pos, iblockstate, entity, numberOfParticles);
        if (!flag)
            world.func_175739_a(EnumParticleTypes.BLOCK_DUST, pos0.func_177958_n() + 0.5, pos0.func_177956_o() + 1, pos0.func_177952_p() + 0.5, numberOfParticles, 0.0D, 0.0D, 0.0D, 0.15000000596046448D, Block.func_176210_f(state1));
        return true;
    }

    @Override
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {}


    // The One Probe Integration
    @Optional.Method(modid = "theoneprobe")
    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        BlockPos pos = data.getPos().func_177972_a(blockState.func_177229_b(field_176387_N));
        IBlockState state = world.func_180495_p(pos);
        if (validateFilled(world, state, data.getPos()) && state.func_177230_c() instanceof IProbeInfoAccessor) {
            ((IProbeInfoAccessor) state.func_177230_c()).addProbeInfo(mode, probeInfo, player, world, state, new ProbeHitData(pos, data.getHitVec(), data.getSideHit(), data.getPickBlock()));
        }
    }
}
