/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;

public class ShapedChoppingRecipe
extends ShapedOreRecipe {
    public final List<ItemStack> outputBlocks;

    public ShapedChoppingRecipe(ResourceLocation location, List<ItemStack> variantItems, ItemStack result, Object ... recipe) {
        super(location, result, recipe);
        this.outputBlocks = variantItems;
        for (ItemStack stack : this.outputBlocks) {
            if (!(Block.getBlockFromItem((Item)stack.getItem()) instanceof BlockHPChoppingBase)) continue;
            for (int i = 0; i < this.input.size(); ++i) {
                Ingredient ingredient = (Ingredient)this.input.get(i);
                if (!ingredient.apply(stack)) continue;
                NonNullList stacks = NonNullList.create();
                Block.getBlockFromItem((Item)stack.getItem()).getSubBlocks(null, stacks);
                this.input.set(i, (Object)Ingredient.fromStacks((ItemStack[])((ItemStack[])stacks.toArray((Object[])new ItemStack[stacks.size()]))));
            }
        }
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCrafting craftMatrix) {
        boolean isTypeChopping = false;
        for (ItemStack outputBlock : this.outputBlocks) {
            if (!(((ItemBlock)outputBlock.getItem()).getBlock() instanceof BlockHPChoppingBase)) continue;
            isTypeChopping = true;
        }
        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
            for (ItemStack ore : this.outputBlocks) {
                ItemStack stack;
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)(stack = craftMatrix.getStackInSlot(i)), (boolean)false) && (!isTypeChopping || !(Block.getBlockFromItem((Item)stack.getItem()) instanceof BlockHPChoppingBase)) || Block.getBlockFromItem((Item)stack.getItem()) == Blocks.AIR) continue;
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.getSimpleRecipeOutput().getItem());
                if (!Configs.general.useDynamicCrafting) {
                    if ("minecraft".equals(ore.getItem().getRegistryName().getResourceDomain())) {
                        return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().getCount(), stack);
                    }
                    return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().getCount(), new ItemStack(Blocks.LOG, 1, 0));
                }
                return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().getCount(), stack);
            }
        }
        return super.getCraftingResult(craftMatrix);
    }

    @Nonnull
    public ItemStack getRecipeOutput() {
        if (!this.outputBlocks.isEmpty() && !this.output.isEmpty()) {
            ItemStack stack = this.outputBlocks.get(0).copy();
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.output.getItem());
            int meta = stack.getMetadata();
            if (meta == Short.MAX_VALUE) {
                stack.setItemDamage(0);
            }
            return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().getCount(), stack);
        }
        return super.getRecipeOutput();
    }

    public ItemStack getSimpleRecipeOutput() {
        return this.output;
    }
}

