package se.gory_moon.horsepower.items;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.blocks.ModBlocks;

public class ItemBlockChopper extends ItemBlock {

    public ItemBlockChopper(Block block) {
        super(block);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();

        if (!block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }

        if (facing == EnumFacing.DOWN || (!worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f(worldIn, pos.func_177984_a())))
            pos = pos.func_177977_b();

        BlockPos posUp = pos.func_177984_a();
        ItemStack itemstack = player.func_184586_b(hand);

        if (!itemstack.func_190926_b()
                && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(this.field_150939_a, pos, false, facing, null)
                && player.func_175151_a(posUp, facing, itemstack) && worldIn.func_190527_a(ModBlocks.BLOCK_CHOPPER_FILLER, pos, false, facing, null))
        {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState blockState = this.field_150939_a.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, player, hand);
            IBlockState blockStateUp = ModBlocks.BLOCK_CHOPPER_FILLER.getStateForPlacement(worldIn, posUp, facing, hitX, hitY, hitZ, EnumFacing.DOWN.func_176745_a(), player, hand);

            if (placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, blockState)) {
                placeBlockAt(itemstack, player, worldIn, posUp, facing, hitX, hitY, hitZ, blockStateUp);
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
                itemstack.func_190918_g(1);
            }

            return EnumActionResult.SUCCESS;
        } else {
            return EnumActionResult.FAIL;
        }
    }
}
