/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.client.renderer.TileEntityChopperRender;
import se.gory_moon.horsepower.client.renderer.TileEntityChoppingBlockRender;
import se.gory_moon.horsepower.client.renderer.TileEntityFillerRender;
import se.gory_moon.horsepower.client.renderer.TileEntityGrindstoneRender;
import se.gory_moon.horsepower.client.renderer.TileEntityHPBaseRenderer;
import se.gory_moon.horsepower.client.renderer.TileEntityHandGrindstoneRender;
import se.gory_moon.horsepower.client.renderer.TileEntityPressRender;
import se.gory_moon.horsepower.proxy.CommonProxy;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.HorsePowerCommand;
import se.gory_moon.horsepower.util.color.ColorGetter;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrindstone.class, (TileEntitySpecialRenderer)new TileEntityGrindstoneRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityChopper.class, (TileEntitySpecialRenderer)new TileEntityChopperRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFiller.class, (TileEntitySpecialRenderer)new TileEntityFillerRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHandGrindstone.class, (TileEntitySpecialRenderer)new TileEntityHandGrindstoneRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityManualChopper.class, (TileEntitySpecialRenderer)new TileEntityChoppingBlockRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPress.class, (TileEntitySpecialRenderer)new TileEntityPressRender());
    }

    @Override
    public void loadComplete() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new HorsePowerCommand());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(resourceManager -> TileEntityHPBaseRenderer.clearDestroyStageicons());
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> {
            TileEntity tileEntity;
            if (worldIn != null && pos != null && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityGrindstone) {
                TileEntityGrindstone te = (TileEntityGrindstone)tileEntity;
                ItemStack outputStack = te.getStackInSlot(1);
                ItemStack secondaryStack = te.getStackInSlot(2);
                if (outputStack.func_190916_E() < secondaryStack.func_190916_E()) {
                    outputStack = secondaryStack;
                }
                if (!OreDictionary.itemMatches((ItemStack)te.renderStack, (ItemStack)outputStack, (boolean)true)) {
                    te.renderStack = outputStack;
                    te.grindColor = !outputStack.func_190926_b() ? ColorGetter.getColors(outputStack, 2).get(0) : null;
                    te.renderStack = outputStack;
                }
                if (te.grindColor != null) {
                    return te.grindColor.getRGB();
                }
            }
            return -1;
        }, new Block[]{ModBlocks.BLOCK_GRINDSTONE});
    }
}

