package se.gory_moon.horsepower.items;

import com.google.common.collect.Maps;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.lib.Constants;
import se.gory_moon.horsepower.lib.Reference;
import se.gory_moon.horsepower.recipes.ChoppingRecipe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@GameRegistry.ObjectHolder(Reference.MODID)
public class ModItems {

    public static final Item FLOUR = new Item().setRegistryName(Constants.FLOUR_ITEM).func_77655_b(Constants.FLOUR_ITEM).func_77637_a(HorsePowerMod.creativeTab);
    public static final Item DOUGH = new Item().setRegistryName(Constants.DOUGH_ITEM).func_77655_b(Constants.DOUGH_ITEM).func_77637_a(HorsePowerMod.creativeTab);

    @Mod.EventBusSubscriber(modid = Reference.MODID)
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<>();

        /**
         * Register this mod's {@link Item}s.
         *
         * @param event The event
         */
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {

            final Item[] items = {FLOUR, DOUGH};

            final IForgeRegistry<Item> registry = event.getRegistry();

            for (final Item item : items) {
                if (!Configs.general.enableFlour && item == FLOUR)
                    continue;
                if (!Configs.general.enableDough && item == DOUGH)
                    continue;

                registry.register(item);
                ITEMS.add(item);
            }
        }
    }

    public static void registerRecipes() {
        if (Configs.general.enableDough) {
            if (Configs.general.enableFlour)
                GameRegistry.addShapelessRecipe(new ItemStack(DOUGH), FLOUR, Items.field_151131_as);
            GameRegistry.addSmelting(DOUGH, new ItemStack(Items.field_151025_P), 0F);
            OreDictionary.registerOre("foodDough", DOUGH);
        }
        if (Configs.general.enableFlour)
            OreDictionary.registerOre("foodFlour", FLOUR);

        GameRegistry.addRecipe(new ShapedOreRecipe(ModBlocks.BLOCK_GRINDSTONE, "LSL", "###", "###", 'S', "stickWood", '#', "stone", 'L', Items.field_151058_ca));
        GameRegistry.addRecipe(new ShapedOreRecipe(ModBlocks.BLOCK_HAND_GRINDSTONE, "  S", "###", "###", 'S', "stickWood", '#', "stone"));
        GameRegistry.addRecipe(new ChoppingRecipe(OreDictionary.getOres("logWood"), ModBlocks.BLOCK_CHOPPER, "LSL", "SFS", "SWS", 'S', "stickWood", 'L', Items.field_151058_ca, 'F', Items.field_151145_ak, 'W', "logWood"));
        if (Configs.general.enableHandChoppingBlock)
            GameRegistry.addRecipe(new ChoppingRecipe(OreDictionary.getOres("logWood"), ModBlocks.BLOCK_MANUAL_CHOPPER, "W", 'W', "logWood"));
        GameRegistry.addRecipe(new ShapedOreRecipe(ModBlocks.BLOCK_PRESS, "LSL", "#P#", "###", 'S', "stickWood", '#', "plankWood", 'L', Items.field_151058_ca, 'P', Blocks.field_150452_aw));
        if (Configs.general.removeVanillaRecipes)
            removeRecipes();
    }

    private static void removeRecipes() {
        Container dummyContainer = new Container() {
            @Override
            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }

            @Override
            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);


        removeRecipe(findMatchingRecipe(setRecipe(crafting, "###", '#', Items.field_151015_O)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_151120_aE)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_189880_di))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_151103_aS)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_185164_cV)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()))));

        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()))));
    }

    private static InventoryCrafting setRecipe(InventoryCrafting crafting, Object... recipeComponents) {
        crafting.func_174888_l();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;

        if (recipeComponents[i] instanceof String[]) {
            String[] astring = (String[])recipeComponents[i++];

            for (String s2 : astring) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }

        Map<Character, ItemStack> map;

        for (map = Maps.newHashMap(); i < recipeComponents.length; i += 2) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = ItemStack.field_190927_a;

            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, 32767);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }

            map.put(character, itemstack);
        }


        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);

            if (map.containsKey(Character.valueOf(c0))) {
                crafting.func_70299_a(l, map.get(Character.valueOf(c0)).func_77946_l());
            }
        }

        return crafting;
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();

        for (int scan = 0; scan < recipes.size(); scan++) {
            IRecipe tmpRecipe = (IRecipe) recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (ItemStack.func_77989_b(resultItem, recipeResult)) {
                recipes.remove(scan);
            }
        }
    }

    private static void removeRecipe(IRecipe recipe) {
        ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();

        if (recipe != null)
            recipes.remove(recipe);
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (irecipe.func_77569_a(craftMatrix, null)) {
                return irecipe;
            }
        }

        return null;
    }
}
