package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.util.Localization;

import javax.annotation.Nullable;

public class TileEntityPress extends TileEntityHPHorseBase {

    private int currentPressStatus;

    public TileEntityPress() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentPressStatus", currentPressStatus);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        if (getStackInSlot(0).func_190916_E() > 0) {
            currentPressStatus = compound.func_74762_e("currentPressStatus");
        } else {
            currentPressStatus = 0;
        }
    }

    @Override
    public void func_70296_d() {
        //if (getStackInSlot(1).isEmpty() && getStackInSlot(2).isEmpty())
            //BlockGrindstone.setState(false, world, pos);

        if (getStackInSlot(0).func_190926_b())
            currentPressStatus = 0;

        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if ((x <= 1 && x >= -1) && (z <= 1 && z >= -1))
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f(field_145850_b, pos))
                return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        currentPressStatus++;

        int totalPress = Configs.general.pointsForPress;
        if (currentPressStatus >= (totalPress <= 0 ? 1: totalPress)) {
            currentPressStatus = 0;

            pressItem();
            return true;
        }
        func_70296_d();
        return false;
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getPressRecipe(getStackInSlot(0));
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getPressResult(getStackInSlot(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    private void pressItem() {
        if (canWork()) {
            HPRecipeBase recipe = getRecipe();
            ItemStack result = recipe.getOutput();

            ItemStack input = getStackInSlot(0);
            ItemStack output = getStackInSlot(1);

            if (output.func_190926_b()) {
                setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }

            input.func_190918_g(input.func_190916_E());
            //BlockGrindstone.setState(true, world, pos);
            func_70296_d();
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = getStackInSlot(index);
        super.setInventorySlotContents(index, stack);

        //if ((index == 1 || index == 2) && getStackInSlot(1).isEmpty() && getStackInSlot(2).isEmpty())
            //BlockGrindstone.setState(false, world, pos);

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag)
            currentPressStatus = 0;

        func_70296_d();
    }

    @Override
    public int getInventoryStackLimit(ItemStack stack) {
        PressRecipe recipe = HPRecipes.instance().getPressRecipe(stack);
        if (recipe == null)
            return getInventoryStackLimit();
        return recipe.getInput().func_190916_E();
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        return currentPressStatus == 0 ? super.removeStackFromSlot(index): ItemStack.field_190927_a;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasPressRecipe(stack) && currentPressStatus == 0 && getStackInSlot(1).func_190926_b();
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0:
                return currentPressStatus;
            default:
                return 0;
        }
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0:
                currentPressStatus = value;
                break;
        }
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public String getName() {
        return "container.press";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Nullable
    @Override
    public ITextComponent func_145748_c_() {
        if (valid)
            return super.func_145748_c_();
        else
            return new TextComponentTranslation(Localization.INFO.PRESS_INVALID.key()).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}
