/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.client.MeshDefinitionFix;
import se.gory_moon.horsepower.client.model.BakedChopperModel;
import se.gory_moon.horsepower.items.ModItems;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModModelManager {
    public static final ModModelManager INSTANCE = new ModModelManager();
    private final Set<Item> itemsRegistered = new HashSet<Item>();
    private static final ResourceLocation MODEL_ChoppingBlock = new ResourceLocation("horsepower", "block/chopper");
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation getModelResourceLocation(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        ModModelManager.replaceChoppingModel(new ModelResourceLocation("horsepower:chopper", "facing=north,part=base"), MODEL_ChoppingBlock, event);
        ModModelManager.replaceChoppingModel(new ModelResourceLocation("horsepower:chopper", "facing=south,part=base"), MODEL_ChoppingBlock, event);
        ModModelManager.replaceChoppingModel(new ModelResourceLocation("horsepower:chopper", "facing=west,part=base"), MODEL_ChoppingBlock, event);
        ModModelManager.replaceChoppingModel(new ModelResourceLocation("horsepower:chopper", "facing=east,part=base"), MODEL_ChoppingBlock, event);
        event.getModelRegistry().putObject((Object)new ModelResourceLocation("horsepower:chopper", "inventory"), event.getModelRegistry().getObject((Object)new ModelResourceLocation("horsepower:chopper", "facing=north,part=base")));
        event.getModelRegistry().putObject((Object)new ModelResourceLocation("horsepower:chopper", "inventory"), event.getModelRegistry().getObject((Object)new ModelResourceLocation("horsepower:chopper", "facing=south,part=base")));
        event.getModelRegistry().putObject((Object)new ModelResourceLocation("horsepower:chopper", "inventory"), event.getModelRegistry().getObject((Object)new ModelResourceLocation("horsepower:chopper", "facing=west,part=base")));
        event.getModelRegistry().putObject((Object)new ModelResourceLocation("horsepower:chopper", "inventory"), event.getModelRegistry().getObject((Object)new ModelResourceLocation("horsepower:chopper", "facing=east,part=base")));
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
    }

    private void registerBlockModels() {
        ModBlocks.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerItemModels() {
        ModItems.RegistrationHandler.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerBlockItemModel(IBlockState state) {
        Block block = state.getBlock();
        Item item = Item.getItemFromBlock((Block)block);
        if (item != null) {
            this.registerItemModel(item, new ModelResourceLocation(block.getRegistryName(), this.propertyStringMapper.getPropertyString((Map)state.getProperties())));
        }
    }

    private void registerBlockItemModelForMeta(IBlockState state, int metadata) {
        Item item = Item.getItemFromBlock((Block)state.getBlock());
        if (item != null) {
            this.registerItemModelForMeta(item, metadata, this.propertyStringMapper.getPropertyString((Map)state.getProperties()));
        }
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private void registerItemModelForMeta(Item item, int metadata, String variant) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }

    public static ModelResourceLocation getModel(String resource) {
        return new ModelResourceLocation("horsepower:" + resource, "inventory");
    }

    public static void replaceChoppingModel(ModelResourceLocation modelVariantLocation, ResourceLocation modelLocation, ModelBakeEvent event) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            if (model instanceof IRetexturableModel) {
                IRetexturableModel tableModel = (IRetexturableModel)model;
                IBakedModel standard = (IBakedModel)event.getModelRegistry().getObject((Object)modelVariantLocation);
                if (standard instanceof IPerspectiveAwareModel) {
                    BakedChopperModel finalModel = new BakedChopperModel((IPerspectiveAwareModel)standard, tableModel, DefaultVertexFormats.BLOCK);
                    event.getModelRegistry().putObject((Object)modelVariantLocation, (Object)finalModel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

