/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.ComparableItemStack;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HandGrindstoneRecipe;

public class HPRecipes {
    private static HPRecipes INSTANCE = new HPRecipes();
    private final Map<ComparableItemStack, GrindstoneRecipe> grindstoneRecipes = Maps.newHashMap();
    private final Map<ComparableItemStack, GrindstoneRecipe> handgrindstoneRecipes = Maps.newHashMap();
    private final Map<ComparableItemStack, ChoppingBlockRecipe> choppingBlockRecipes = Maps.newHashMap();
    public static ArrayList<String> ERRORS = Lists.newArrayList();
    public static boolean serverSyncedRecipes = false;

    public static HPRecipes instance() {
        return INSTANCE;
    }

    private HPRecipes() {
    }

    public void reloadRecipes() {
        if (!serverSyncedRecipes) {
            this.reloadRecipes(Arrays.asList(Configs.grindstoneRecipes), Arrays.asList(Configs.handGrindstoneRecipes), Arrays.asList(Configs.choppingRecipes));
        }
    }

    public void reloadRecipes(List<String> grindstone, List<String> handGrindstone, List<String> chopping) {
        HorsePowerMod.jeiPlugin.removeRecipe();
        this.grindstoneRecipes.clear();
        this.handgrindstoneRecipes.clear();
        this.choppingBlockRecipes.clear();
        this.createRecipes(GrindstoneRecipe.class, grindstone).forEach(this::addGrindstoneRecipe);
        this.createRecipes(HandGrindstoneRecipe.class, handGrindstone).forEach(this::addHandGrindstoneRecipe);
        this.createRecipes(ChoppingBlockRecipe.class, chopping).forEach(this::addChoppingRecipe);
        HorsePowerMod.jeiPlugin.addRecipes();
        HorsePowerMod.tweakerPlugin.applyTweaker();
    }

    private <T extends HPRecipeBase> List<T> createRecipes(Class<T> clazz, List<String> data) {
        ArrayList<T> recipes = new ArrayList<T>();
        for (String aData : data) {
            Object[] comp = aData.split("-");
            if (aData.isEmpty()) continue;
            ArrayList stacks = Lists.newArrayList();
            int time = -1;
            int secondaryChance = 0;
            for (String string : comp) {
                if (string.contains(":")) {
                    Object stack;
                    try {
                        stack = this.parseItemStack(string);
                    }
                    catch (Exception e) {
                        this.errorMessage("Parse error with " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe item '" + string + "' from config" + (stacks.size() > 0 ? " with item" + stacks.get(0) : "") + ".");
                        break;
                    }
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                if (stacks.size() == 2) {
                    try {
                        time = Integer.parseInt(string);
                    }
                    catch (NumberFormatException e) {
                        this.errorMessage("Parse error with " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe time '" + string + "' from config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                        time = -1;
                    }
                    continue;
                }
                if (stacks.size() != 3) continue;
                try {
                    secondaryChance = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    this.errorMessage("Parse error with " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe secondary chance '" + secondaryChance + "' from config for input " + stacks.get(0) + ", output " + stacks.get(1) + " and secondary " + stacks.get(2));
                }
            }
            boolean flag = false;
            if (stacks.size() >= 2 && time > -1 && (stacks.size() != 3 || secondaryChance != 0)) {
                try {
                    if (stacks.get(0) instanceof List) {
                        for (Object stack : (List)stacks.get(0)) {
                            ItemStack itemStack = (ItemStack)stack;
                            itemStack.func_190920_e(1);
                            ItemStack secondary = stacks.size() == 3 ? (ItemStack)stacks.get(2) : ItemStack.field_190927_a;
                            recipes.add(clazz.getConstructor(ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE).newInstance(itemStack, stacks.get(1), secondary, secondaryChance, time));
                        }
                    } else {
                        ItemStack in = (ItemStack)stacks.get(0);
                        in.func_190920_e(1);
                        ItemStack secondary = stacks.size() == 3 ? (ItemStack)stacks.get(2) : ItemStack.field_190927_a;
                        recipes.add(clazz.getConstructor(ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE).newInstance(in, stacks.get(1), secondary, secondaryChance, time));
                    }
                    flag = true;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (flag) continue;
            this.errorMessage("Couldn't load " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe (" + Joiner.on((String)"-").join(comp) + ")");
        }
        return recipes;
    }

    private void errorMessage(String message) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (FMLClientHandler.instance().getClientPlayerEntity() != null) {
                FMLClientHandler.instance().getClientPlayerEntity().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + message));
            } else {
                ERRORS.add(message);
            }
        }
        HorsePowerMod.logger.warn(message);
    }

    private Object parseItemStack(String item) throws Exception {
        int meta;
        int amount;
        NBTTagCompound nbt;
        String[] data = item.split("\\$");
        NBTTagCompound nBTTagCompound = nbt = data.length == 1 ? null : JsonToNBT.func_180713_a((String)data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("$"));
        }
        int n = amount = (data = item.split("@")).length == 1 ? 1 : Integer.parseInt(data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("@"));
        }
        int n2 = (data = item.split(":")).length == 2 ? 0 : (meta = "*".equals(data[2]) ? Short.MAX_VALUE : Integer.parseInt(data[2]));
        if (item.startsWith("ore:")) {
            return OreDictionary.getOres((String)item.substring(4));
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", data[0] + ":" + data[1]);
        compound.func_74774_a("Count", (byte)amount);
        compound.func_74777_a("Damage", (short)meta);
        if (nbt != null) {
            compound.func_74782_a("tag", (NBTBase)nbt);
        }
        return new ItemStack(compound);
    }

    public void addGrindstoneRecipe(Block input, ItemStack output, int time, boolean hand) {
        this.addGrindstoneRecipe(Item.func_150898_a((Block)input), output, time, hand);
    }

    public void addGrindstoneRecipe(Item input, ItemStack output, int time, boolean hand) {
        this.addGrindstoneRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time, hand);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, int time, boolean hand) {
        if (this.getGrindstoneResult(input, hand) != ItemStack.field_190927_a) {
            return;
        }
        this.addGrindstoneRecipe(input, output, ItemStack.field_190927_a, 0, time, hand);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, ItemStack secondary, int secondaryChance, int time, boolean hand) {
        if (this.getGrindstoneResult(input, hand) != ItemStack.field_190927_a) {
            return;
        }
        this.addGrindstoneRecipe(new GrindstoneRecipe(input, output, secondary, secondaryChance, time), hand);
    }

    public void addGrindstoneRecipe(GrindstoneRecipe recipe, boolean hand) {
        if (this.getGrindstoneResult(recipe.getInput(), hand) != ItemStack.field_190927_a) {
            return;
        }
        if (hand && Configs.useSeperateRecipes) {
            this.addHandGrindstoneRecipe(recipe);
        } else {
            this.addGrindstoneRecipe(recipe);
        }
    }

    private void addGrindstoneRecipe(GrindstoneRecipe recipe) {
        this.grindstoneRecipes.put(new ComparableItemStack(recipe.getInput()), recipe);
    }

    private void addHandGrindstoneRecipe(GrindstoneRecipe recipe) {
        this.handgrindstoneRecipes.put(new ComparableItemStack(recipe.getInput()), recipe);
    }

    public void addChoppingRecipe(Block input, ItemStack output, int time) {
        this.addChoppingRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addChoppingRecipe(Item input, ItemStack output, int time) {
        this.addChoppingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addChoppingRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getChopperResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.addChoppingRecipe(input, output, ItemStack.field_190927_a, 0, time);
    }

    public void addChoppingRecipe(ItemStack input, ItemStack output, ItemStack secondary, int secondaryChance, int time) {
        if (this.getChopperResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.addChoppingRecipe(new ChoppingBlockRecipe(input, output, ItemStack.field_190927_a, secondaryChance, time));
    }

    public void addChoppingRecipe(ChoppingBlockRecipe recipe) {
        if (this.getChopperResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.choppingBlockRecipes.put(new ComparableItemStack(recipe.getInput()), recipe);
    }

    public void removeGrindstoneRecipe(GrindstoneRecipe recipe, boolean hand) {
        this.removeGrindstoneRecipe(recipe.getInput(), hand);
    }

    public void removeGrindstoneRecipe(ItemStack input, boolean hand) {
        if (hand && Configs.useSeperateRecipes) {
            this.handgrindstoneRecipes.remove(new ComparableItemStack(input));
        } else {
            this.grindstoneRecipes.remove(new ComparableItemStack(input));
        }
    }

    public void removeChoppingRecipe(ChoppingBlockRecipe recipe) {
        this.removeChoppingRecipe(recipe.getInput());
    }

    public void removeChoppingRecipe(ItemStack input) {
        this.choppingBlockRecipes.remove(new ComparableItemStack(input));
    }

    public GrindstoneRecipe getGrindstoneRecipe(ItemStack stack, boolean hand) {
        if (stack.func_190926_b()) {
            return null;
        }
        return hand && Configs.useSeperateRecipes ? this.handgrindstoneRecipes.get(new ComparableItemStack(stack)) : this.grindstoneRecipes.get(new ComparableItemStack(stack));
    }

    public ChoppingBlockRecipe getChoppingBlockRecipe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return this.choppingBlockRecipes.get(new ComparableItemStack(stack));
    }

    public ItemStack getGrindstoneResult(ItemStack stack, boolean hand) {
        GrindstoneRecipe recipe = this.getGrindstoneRecipe(stack, hand);
        return recipe != null ? recipe.getOutput() : ItemStack.field_190927_a;
    }

    public ItemStack getGrindstoneSecondary(ItemStack stack, boolean hand) {
        GrindstoneRecipe recipe = this.getGrindstoneRecipe(stack, hand);
        return recipe != null ? recipe.getSecondary() : ItemStack.field_190927_a;
    }

    public ItemStack getChopperResult(ItemStack stack) {
        ChoppingBlockRecipe recipe = this.getChoppingBlockRecipe(stack);
        return recipe != null ? recipe.getOutput() : ItemStack.field_190927_a;
    }

    public boolean hasGrindstoneRecipe(ItemStack stack, boolean hand) {
        return this.getGrindstoneRecipe(stack, hand) != null;
    }

    public boolean hasChopperRecipe(ItemStack stack) {
        return this.getChoppingBlockRecipe(stack) != null;
    }

    public ArrayList<GrindstoneRecipe> getGrindstoneRecipes() {
        return new ArrayList<GrindstoneRecipe>(this.grindstoneRecipes.values());
    }

    public ArrayList<GrindstoneRecipe> getHandGrindstoneRecipes() {
        return new ArrayList<GrindstoneRecipe>(this.handgrindstoneRecipes.values());
    }

    public ArrayList<ChoppingBlockRecipe> getChoppingRecipes() {
        return new ArrayList<ChoppingBlockRecipe>(this.choppingBlockRecipes.values());
    }

    public int getGrindstoneTime(ItemStack stack, boolean hand) {
        GrindstoneRecipe recipe = this.getGrindstoneRecipe(stack, hand);
        return recipe != null ? recipe.getTime() : 16;
    }

    public int getChoppingTime(ItemStack stack) {
        ChoppingBlockRecipe recipe = this.getChoppingBlockRecipe(stack);
        return recipe != null ? recipe.getTime() : 1;
    }
}

