/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.ChoppingBlock")
public class ChoppingRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output, int time) {
        List items = input.getItems();
        if (items == null) {
            HorsePowerMod.logger.error("Cannot turn " + input.toString() + " into a chopping recipe");
        }
        ItemStack[] items2 = MineTweakerMC.getItemStacks((List)items);
        ItemStack output2 = MineTweakerMC.getItemStack((IItemStack)output);
        AddChoppingRecipe recipe = new AddChoppingRecipe(input, items2, output2, ItemStack.EMPTY, 0, time);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            ChoppingBlockRecipe recipe = HPRecipes.instance().getChoppingRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)MineTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemoveChoppingRecipe recipe = new RemoveChoppingRecipe(toRemove, removeIndex);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemoveChoppingRecipe
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<ChoppingBlockRecipe> recipes;

        private RemoveChoppingRecipe(List<ChoppingBlockRecipe> recipes, List<Integer> removingIndices) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
        }

        public void apply() {
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                HPRecipes.instance().getChoppingRecipes().remove(this.removingIndices.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipes.get(i), "horsepower.chopping");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(HPRecipes.instance().getGrindstoneRecipes().size(), this.removingIndices.get(i));
                HPRecipes.instance().getChoppingRecipes().add(index, this.recipes.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipes.get(i), "horsepower.chopping");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " chopping recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.recipes.size() + " chopping recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddChoppingRecipe
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;

        public AddChoppingRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, ItemStack secondary, int secondaryChance, int time) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                ChoppingBlockRecipe recipe = new ChoppingBlockRecipe(stack, this.output, this.secondary, this.secondary.isEmpty() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addChoppingRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe, "horsepower.chopping");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack stack : this.input) {
                ChoppingBlockRecipe recipe = HPRecipes.instance().getChoppingBlockRecipe(stack);
                HPRecipes.instance().removeChoppingRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe, "horsepower.chopping");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Adding chopping recipe for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing chopping recipe for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

