/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Utils;

public abstract class TileEntityHPHorseBase
extends TileEntityHPBase
implements ITickable {
    protected static double[][] path = new double[][]{{-1.5, -1.5}, {0.0, -1.5}, {1.0, -1.5}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {-1.5, 1.0}, {-1.5, 0.0}};
    protected AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    protected List<BlockPos> searchPos = null;
    protected int origin;
    protected int target = this.origin = -1;
    protected boolean hasWorker = false;
    protected EntityCreature worker;
    protected NBTTagCompound nbtWorker;
    protected boolean valid = false;
    protected int validationTimer = 0;
    protected int locateHorseTimer = 0;
    protected boolean running = true;
    protected boolean wasRunning = false;

    public TileEntityHPHorseBase(int inventorySize) {
        super(inventorySize);
    }

    public abstract boolean validateArea();

    public abstract boolean targetReached();

    public abstract int getPositionOffset();

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.target = compound.getInteger("target");
        this.origin = compound.getInteger("origin");
        this.hasWorker = compound.getBoolean("hasWorker");
        if (this.hasWorker && compound.hasKey("leash", 10)) {
            this.nbtWorker = compound.getCompoundTag("leash");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("target", this.target);
        compound.setInteger("origin", this.origin);
        compound.setBoolean("hasWorker", this.hasWorker);
        if (this.worker != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = this.worker.getUniqueID();
            nbtTagCompound.setUniqueId("UUID", uuid);
            compound.setTag("leash", (NBTBase)nbtTagCompound);
        }
        return super.writeToNBT(compound);
    }

    public void setWorker(EntityCreature newWorker) {
        this.hasWorker = true;
        this.worker = newWorker;
        this.worker.setHomePosAndDistance(this.pos, 3);
        this.target = this.getClosestTarget();
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (this.hasWorker() && this.worker.canBeLeashedTo(player)) {
            this.hasWorker = false;
            this.worker.detachHome();
            this.worker.setLeashedToEntity((Entity)player, true);
            this.worker = null;
        }
    }

    public boolean hasWorker() {
        if (this.worker != null && !this.worker.isDead && !this.worker.getLeashed() && this.worker.getDistanceSq(this.pos) < 45.0) {
            return true;
        }
        if (this.worker != null) {
            this.worker = null;
            if (!this.getWorld().isRemote) {
                InventoryHelper.spawnItemStack((World)this.world, (double)this.pos.getX(), (double)(this.pos.getY() + 1), (double)this.pos.getZ(), (ItemStack)new ItemStack(Items.LEAD));
            }
        }
        this.hasWorker = false;
        return false;
    }

    public EntityCreature getWorker() {
        return this.worker;
    }

    private Vec3d getPathPosition(int i) {
        double x = (double)this.pos.getX() + path[i][0] * 2.0;
        double y = this.pos.getY() + this.getPositionOffset();
        double z = (double)this.pos.getZ() + path[i][1] * 2.0;
        return new Vec3d(x, y, z);
    }

    protected int getClosestTarget() {
        if (this.hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;
            for (int i = 0; i < path.length; ++i) {
                Vec3d pos = this.getPathPosition(i);
                double x = pos.xCoord;
                double y = pos.yCoord;
                double z = pos.zCoord;
                double tmp = this.worker.getDistance(x, y, z);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closest = i;
            }
            return closest;
        }
        return 0;
    }

    public void update() {
        --this.validationTimer;
        if (this.validationTimer <= 0) {
            this.valid = this.validateArea();
            this.validationTimer = this.valid ? 220 : 60;
        }
        if (!this.hasWorker()) {
            --this.locateHorseTimer;
        }
        if (!this.hasWorker() && this.nbtWorker != null && this.locateHorseTimer <= 0) {
            UUID uuid = this.nbtWorker.getUniqueId("UUID");
            int x = this.pos.getX();
            int y = this.pos.getY();
            int z = this.pos.getZ();
            ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
            block0: for (Class<? extends EntityCreature> clazz : clazzes) {
                for (Object entity : this.world.getEntitiesWithinAABB(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                    EntityCreature creature;
                    if (!(entity instanceof EntityCreature) || !(creature = (EntityCreature)entity).getUniqueID().equals(uuid)) continue;
                    this.setWorker(creature);
                    break block0;
                }
            }
        }
        if (this.locateHorseTimer <= 0) {
            this.locateHorseTimer = 220;
        }
        boolean flag = false;
        if (!this.world.isRemote && this.valid) {
            if (!this.running && this.canWork()) {
                this.running = true;
            } else if (this.running && !this.canWork()) {
                this.running = false;
            }
            if (this.running != this.wasRunning) {
                this.target = this.getClosestTarget();
                this.wasRunning = this.running;
            }
            if (this.hasWorker() && this.running) {
                Vec3d pos = this.getPathPosition(this.target);
                double x = pos.xCoord;
                double y = pos.yCoord;
                double z = pos.zCoord;
                if (this.searchAreas[this.target] == null) {
                    this.searchAreas[this.target] = new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
                }
                if (this.worker.getEntityBoundingBox().intersectsWith(this.searchAreas[this.target])) {
                    int next = this.target + 1;
                    int previous = this.target - 1;
                    if (next >= path.length) {
                        next = 0;
                    }
                    if (previous < 0) {
                        previous = path.length - 1;
                    }
                    if (this.origin != this.target && this.target != previous) {
                        this.origin = this.target;
                        flag = this.targetReached();
                    }
                    this.target = next;
                }
                if (this.worker instanceof AbstractHorse && ((AbstractHorse)this.worker).isEatingHaystack()) {
                    ((AbstractHorse)this.worker).setEatingHaystack(false);
                }
                if (this.target != -1 && this.worker.getNavigator().noPath()) {
                    pos = this.getPathPosition(this.target);
                    x = pos.xCoord;
                    y = pos.yCoord;
                    z = pos.zCoord;
                    this.worker.getNavigator().tryMoveToXYZ(x, y, z, 1.0);
                }
            }
        }
        if (flag) {
            this.markDirty();
        }
    }
}

