/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Localization;

public class TileEntityGrindstone
extends TileEntityHPHorseBase {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private int currentItemMillTime;
    private int totalItemMillTime;

    public TileEntityGrindstone() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", this.currentItemMillTime);
        compound.func_74768_a("totalMillTime", this.totalItemMillTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemMillTime = compound.func_74762_e("millTime");
            this.totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        if (this.func_70301_a(1).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
        }
        if (this.func_70301_a(0).func_190926_b()) {
            this.currentItemMillTime = 0;
        }
        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_175623_d(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentItemMillTime;
        if (this.currentItemMillTime >= this.totalItemMillTime) {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(this.func_70301_a(0));
            this.millItem();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(this.func_70301_a(0));
    }

    @Override
    public int getPositionOffset() {
        return -1;
    }

    private void millItem() {
        if (this.canWork()) {
            ItemStack input = this.func_70301_a(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
            BlockGrindstone.setState(true, this.field_145850_b, this.field_174879_c);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean flag;
        super.func_70299_a(index, stack);
        if (index == 1 && this.func_70301_a(1).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
        ItemStack itemstack = this.func_70301_a(index);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    public String func_70005_c_() {
        return "container.mill";
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.valid) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}

