package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.HPRecipes;

public class TileEntityGrindstone extends TileEntityHPHorseBase {

    private static final int[] SLOTS_TOP = new int[] {0};
    private static final int[] SLOTS_BOTTOM = new int[] {1};

    private int currentItemMillTime;
    private int totalItemMillTime;

    public TileEntityGrindstone() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", currentItemMillTime);
        compound.func_74768_a("totalMillTime", totalItemMillTime);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        if (func_70301_a(0).func_190916_E() > 0) {
            currentItemMillTime = compound.func_74762_e("millTime");
            totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            currentItemMillTime = 0;
            totalItemMillTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        if (func_70301_a(1).func_190926_b())
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);

        if (func_70301_a(0).func_190926_b())
            currentItemMillTime = 0;

        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if (x == 0 && z == 0)
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_175623_d(pos))
                return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        currentItemMillTime++;

        if (currentItemMillTime >= totalItemMillTime) {
            currentItemMillTime = 0;

            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(func_70301_a(0));
            millItem();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(func_70301_a(0));
    }

    @Override
    public int getPositionOffset() {
        return -1;
    }

    private void millItem() {
        if (canWork()) {
            ItemStack input = func_70301_a(0);
            ItemStack result = getRecipeItemStack();
            ItemStack output = func_70301_a(1);

            if (output.func_190926_b()) {
                func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }

            input.func_190918_g(1);
            BlockGrindstone.setState(true, field_145850_b, field_174879_c);
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[0]);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);

        if (index == 1 && func_70301_a(1).func_190926_b()) {
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);
            func_70296_d();
        }

        ItemStack itemstack = func_70301_a(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag) {
            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack);
            currentItemMillTime = 0;
            func_70296_d();
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0:
                return totalItemMillTime;
            case 1:
                return currentItemMillTime;
            default:
                return 0;
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0:
                totalItemMillTime = value;
                break;
            case 1:
                currentItemMillTime = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public String func_70005_c_() {
        return "container.mill";
    }
}
