/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityChopper
extends TileEntityHPBase {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_SIDE = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;

    public TileEntityChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentWindup", this.currentWindup);
        compound.func_74768_a("chopTime", this.currentItemChopTime);
        compound.func_74768_a("totalChopTime", this.totalItemChopTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentWindup = compound.func_74762_e("currentWindup");
        if (this.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemChopTime = compound.func_74762_e("chopTime");
            this.totalItemChopTime = compound.func_74762_e("totalChopTime");
        } else {
            this.currentItemChopTime = 0;
            this.totalItemChopTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack) && this.func_70301_a(1).func_190926_b() && this.func_70301_a(0).func_190926_b();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_175623_d(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentWindup;
        if (this.currentWindup >= Configs.pointsForWindup) {
            this.currentWindup = 0;
            ++this.currentItemChopTime;
            if (this.currentItemChopTime >= this.totalItemChopTime) {
                this.currentItemChopTime = 0;
                this.totalItemChopTime = HPRecipes.instance().getChopperTime(this.func_70301_a(0));
                this.chopItem();
                return true;
            }
        }
        return false;
    }

    private void chopItem() {
        if (this.canWork()) {
            ItemStack input = this.func_70301_a(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.func_70301_a(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDE);
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopTime;
            }
            case 1: {
                return this.currentItemChopTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopTime = value;
                break;
            }
            case 1: {
                this.currentItemChopTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    public String func_70005_c_() {
        return "container.chopper";
    }
}

