/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Utils;

public abstract class BlockHPBase
extends Block {
    protected static boolean keepInventory = false;

    public BlockHPBase(Material materialIn) {
        super(materialIn);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityHPBase te;
        super.func_176208_a(worldIn, pos, state, player);
        if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K && (te = this.getTileEntity(worldIn, pos)) != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)te);
            if (te.hasWorker()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)new ItemStack(Items.field_151058_ca));
            }
        }
    }

    private TileEntityHPBase getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityHPBase ? (TileEntityHPBase)tileentity : null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && !worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityGrindstone) {
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack result;
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntityHPBase tileEntityHPBase = (TileEntityHPBase)worldIn.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        EntityCreature creature = null;
        ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
        block0: for (Class<? extends EntityCreature> clazz : clazzes) {
            for (Object entity : worldIn.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                EntityCreature tmp;
                if (!(entity instanceof EntityCreature) || !(tmp = (EntityCreature)entity).func_110167_bD() || tmp.func_110166_bE() != playerIn) continue;
                creature = tmp;
                break block0;
            }
        }
        if (stack.func_77973_b() instanceof ItemLead && creature != null || creature != null) {
            if (!tileEntityHPBase.hasWorker()) {
                creature.func_110160_i(true, false);
                tileEntityHPBase.setWorker(creature);
                return true;
            }
            return false;
        }
        if (!stack.func_190926_b() && tileEntityHPBase.func_94041_b(0, stack)) {
            ItemStack itemStack = tileEntityHPBase.func_70301_a(0);
            boolean flag = false;
            if (itemStack.func_190926_b()) {
                tileEntityHPBase.func_70299_a(0, stack.func_77946_l());
                stack.func_190920_e(0);
                flag = true;
            } else if (TileEntityHPBase.canCombine(itemStack, stack)) {
                int i = stack.func_77976_d() - itemStack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemStack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                return true;
            }
        }
        if ((result = tileEntityHPBase.func_70304_b(1)).func_190926_b() && stack.func_190926_b() && hand != EnumHand.OFF_HAND) {
            result = tileEntityHPBase.func_70304_b(0);
            BlockGrindstone.setState(false, worldIn, pos);
        }
        if (result.func_190926_b()) {
            if (!stack.func_190926_b()) {
                return false;
            }
            tileEntityHPBase.setWorkerToPlayer(playerIn);
        }
        if (stack.func_190926_b()) {
            playerIn.func_184611_a(hand, result);
        } else if (playerIn.func_191521_c(result)) {
            playerIn.func_71019_a(result, false);
        }
        tileEntityHPBase.func_70296_d();
        return true;
    }
}

