/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFiller
extends BlockDirectional {
    public static final IUnlistedProperty<Integer> MISC_DATA = Properties.toUnlisted((IProperty)PropertyInteger.create((String)"misc_data", (int)0, (int)32));

    public BlockFiller(Material materialIn, String name) {
        super(materialIn);
        this.setRegistryName(name + "filler");
    }

    private IBlockState getFillerState(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos);
    }

    private int getValue(IExtendedBlockState state, int location, int size) {
        return (Integer)state.getValue(MISC_DATA) >> location & (1 << size) - 1;
    }

    private int setValue(int meta, int location, int value) {
        return meta | value << location;
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{MISC_DATA});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState getActualState(IBlockState baseState, IBlockAccess worldIn, BlockPos pos) {
        if (baseState instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)baseState;
            IBlockState state1 = worldIn.getBlockState(pos = pos.offset((EnumFacing)extState.getValue((IProperty)FACING)));
            int meta = this.setValue(state1.getBlock().canProvidePower(state1) ? 1 : 0, 0, 1);
            return ((IExtendedBlockState)baseState).withProperty(MISC_DATA, (Object)meta);
        }
        return super.getActualState(baseState, worldIn, pos);
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return false;
    }

    public boolean isBlockNormalCube(IBlockState state) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.getBlockState(pos);
        if (!((World)world).isRemote && pos.equals((Object)neighbor.offset((EnumFacing)state.getValue((IProperty)FACING)))) {
            ((World)world).setBlockState(pos, Blocks.AIR.getDefaultState(), 3);
        }
    }

    public void onBlockDestroyedByPlayer(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        worldIn.setBlockState(pos, Blocks.AIR.getDefaultState());
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = world.getBlockState(pos);
        return state1.getBlock().getBoundingBox(state1, world, pos);
    }

    public boolean onBlockActivated(World w, BlockPos p, IBlockState s, EntityPlayer e, EnumHand h, EnumFacing f, float x, float y, float z) {
        p = p.offset((EnumFacing)s.getValue((IProperty)FACING));
        IBlockState state1 = w.getBlockState(p);
        return state1.getBlock().onBlockActivated(w, p, state1, e, h, f, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB getSelectedBoundingBox(IBlockState s, World w, BlockPos p) {
        p = p.offset((EnumFacing)s.getValue((IProperty)FACING));
        IBlockState state1 = w.getBlockState(p);
        return state1.getBlock().getSelectedBoundingBox(state1, w, p);
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = worldIn.getBlockState(pos);
        state1.getBlock().addCollisionBoxToList(state1, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    public final RayTraceResult collisionRayTrace(IBlockState s, World w, BlockPos p, Vec3d start, Vec3d end) {
        BlockPos p2 = p.offset((EnumFacing)s.getValue((IProperty)FACING));
        IBlockState state1 = w.getBlockState(p2);
        RayTraceResult trace = state1.getBlock().collisionRayTrace(state1, w, p2, start, end);
        return trace != null ? new RayTraceResult(trace.typeOfHit, trace.hitVec, trace.sideHit, p) : trace;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = world.getBlockState(pos);
        return state1.getBlock().shouldCheckWeakPower(state1, world, pos, side);
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.offset((EnumFacing)blockState.getValue((IProperty)FACING));
        IBlockState state1 = blockAccess.getBlockState(pos);
        return state1.getBlock().getStrongPower(state1, blockAccess, pos, side);
    }

    public boolean canProvidePower(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            return this.getValue((IExtendedBlockState)state, 0, 1) == 1;
        }
        return super.canProvidePower(state);
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.offset((EnumFacing)blockState.getValue((IProperty)FACING));
        IBlockState state1 = blockAccess.getBlockState(pos);
        return state1.getBlock().getWeakPower(state1, blockAccess, pos, side);
    }

    public void onEntityWalk(World worldIn, BlockPos pos, Entity entityIn) {
        pos = pos.offset((EnumFacing)worldIn.getBlockState(pos).getValue((IProperty)FACING));
        IBlockState state1 = worldIn.getBlockState(pos);
        state1.getBlock().onEntityWalk(worldIn, pos, entityIn);
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = worldIn.getBlockState(pos);
        return state1.getBlock().getItem(worldIn, pos, state1);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = world.getBlockState(pos);
        return state1.getBlock().getPickBlock(state, target, world, pos, player);
    }

    public boolean causesSuffocation(IBlockState state) {
        return true;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        pos = pos.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = world.getBlockState(pos);
        return state1.getBlock().getSoundType(state1, world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.getBlockPos().offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = worldObj.getBlockState(pos);
        return state1.getBlock().addHitEffects(state1, worldObj, target, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        pos = pos.offset((EnumFacing)world.getBlockState(pos).getValue((IProperty)FACING));
        IBlockState state1 = world.getBlockState(pos);
        return state1.getBlock().addDestroyEffects(world, pos, manager);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        BlockPos pos = blockPosition.offset((EnumFacing)state.getValue((IProperty)FACING));
        IBlockState state1 = worldObj.getBlockState(pos);
        return state1.getBlock().addLandingEffects(state1, worldObj, pos, iblockstate, entity, numberOfParticles);
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }
}

