/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config
extends Configuration {
    public static final String CATEGORY_GAMERULES = "gamerules";
    public static final String CATEGORY_MISC = "misc";
    public static final String MISC_WORLDDIFFICULTY = "worldDifficulty";
    public static final String MISC_WORLDDIFFICULTYLOCK = "worldDifficultyLocked";
    public HashMap<String, Value> rules = new HashMap();
    public HashMap<String, Value> misc = new HashMap();
    public HashMap<String, Value> defaults;
    public HashMap<String, String> comments = new HashMap();

    public Config(File name) {
        super(name);
        this.rules.put("doFireTick", new Value("true", ValueType.BOOLEAN));
        this.rules.put("mobGriefing", new Value("true", ValueType.BOOLEAN));
        this.rules.put("keepInventory", new Value("false", ValueType.BOOLEAN));
        this.rules.put("doMobSpawning", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doMobLoot", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doTileDrops", new Value("true", ValueType.BOOLEAN));
        this.rules.put("commandBlockOutput", new Value("true", ValueType.BOOLEAN));
        this.rules.put("naturalRegeneration", new Value("true", ValueType.BOOLEAN));
        this.rules.put("doDaylightCycle", new Value("true", ValueType.BOOLEAN));
        this.rules.put("logAdminCommands", new Value("true", ValueType.BOOLEAN));
        this.rules.put("showDeathMessages", new Value("true", ValueType.BOOLEAN));
        this.rules.put("randomTickSpeed", new Value("3", ValueType.INTEGER));
        this.rules.put("sendCommandFeedback", new Value("true", ValueType.BOOLEAN));
        this.rules.put("reducedDebugInfo", new Value("false", ValueType.BOOLEAN));
        this.rules.put("spectatorsGenerateChunks", new Value("true", ValueType.BOOLEAN));
        this.rules.put("spawnRadius", new Value("10", ValueType.INTEGER));
        this.rules.put("disableElytraMovementCheck", new Value("false", ValueType.BOOLEAN));
        this.misc.put(MISC_WORLDDIFFICULTY, new Value("-1", ValueType.INTEGER));
        this.misc.put(MISC_WORLDDIFFICULTYLOCK, new Value("false", ValueType.BOOLEAN));
        this.comments.put("doFireTick", "Whether fire should spread and naturally extinguish");
        this.comments.put("mobGriefing", "Whether creepers, zombies, endermen, ghasts, withers, rabbits, sheep, and villagers should be able to change blocks and whether villagers, zombies, skeletons, and zombie pigmen can pick up items");
        this.comments.put("keepInventory", "Whether the player should keep items in their inventory after death");
        this.comments.put("doMobSpawning", "Whether mobs should naturally spawn");
        this.comments.put("doMobLoot", "Whether mobs should drop items");
        this.comments.put("doTileDrops", "Whether blocks should have drops");
        this.comments.put("commandBlockOutput", "Whether command blocks should notify admins when they perform commands");
        this.comments.put("naturalRegeneration", "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)");
        this.comments.put("doDaylightCycle", "Whether time progresses");
        this.comments.put("logAdminCommands", "Whether to log admin commands to server log");
        this.comments.put("showDeathMessages", "Whether a message appears in chat when a player dies");
        this.comments.put("randomTickSpeed", "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 will disable random ticks, higher numbers will increase random ticks");
        this.comments.put("sendCommandFeedback", "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text");
        this.comments.put("reducedDebugInfo", "Whether the debug screen shows all or reduced infomation");
        this.comments.put("spectatorsGenerateChunks", "Whether players in spectator mode can generate chunks");
        this.comments.put("spawnRadius", "The number of blocks outward from the world spawn coordinates that a player will spawn in when first joining a server or when dying without a spawnpoint.");
        this.comments.put("disableElytraMovementCheck", "Whether the server should skip checking player speed when the player is wearing elytra.");
        this.comments.put(MISC_WORLDDIFFICULTY, "Sets the difficulty of a world when loaded, respects it the difficulty is locked or not for the world\n-1: Disabled\n0: Peaceful\n1: Easy\n2: Normal\n3: Hard");
        this.comments.put(MISC_WORLDDIFFICULTYLOCK, "If a world's difficulty should be locked when loaded, if world already is locked it can't be change\nIf the global world difficulty is enabled it's set first");
        this.addCustomCategoryComment(CATEGORY_GAMERULES, "Set the values to ('true'/'false' or an integer value) depending if you want to have the GameRule (enabled/disabled or have a different value)");
        this.addCustomCategoryComment(CATEGORY_MISC, "A collection of misc configs");
        this.defaults = (HashMap)this.rules.clone();
        this.defaults.putAll((Map)this.misc.clone());
    }

    public Config loadConfig() {
        this.load();
        this.syncConfigs();
        this.saveConfig();
        this.save();
        return this;
    }

    public void saveConfig() {
        ConfigCategory ruleCat = this.getCategory(CATEGORY_GAMERULES);
        this.setValueToProp(ruleCat, this.rules);
        ConfigCategory miscCat = this.getCategory(CATEGORY_MISC);
        this.setValueToProp(miscCat, this.misc);
        if (this.hasChanged()) {
            this.save();
        }
    }

    private void setValueToProp(ConfigCategory cat, HashMap<String, Value> list) {
        for (Map.Entry<String, Value> entry : list.entrySet()) {
            String key = entry.getKey();
            Value val = entry.getValue();
            Property prop = cat.get(key);
            if (val.getType().equals((Object)ValueType.BOOLEAN)) {
                prop.setValue(val.getBooleanValue());
            } else {
                prop.setValue(val.getIntegerValue());
            }
            prop.setRequiresWorldRestart(true);
            prop.setShowInGui(val.getShowInGui());
            cat.put(key, prop);
        }
    }

    public void syncConfigs() {
        this.syncConfigs(this.rules, CATEGORY_GAMERULES);
        this.syncConfigs(this.misc, CATEGORY_MISC);
        if (this.hasChanged()) {
            this.save();
        }
    }

    private void syncConfigs(HashMap<String, Value> list, String cat) {
        for (Map.Entry<String, Value> entry : list.entrySet()) {
            String key = entry.getKey();
            Value val = entry.getValue();
            String newVal = val.getType().equals((Object)ValueType.BOOLEAN) ? String.valueOf(this.get(cat, key, this.defaults.get(key).getBooleanValue(), this.comments.get(key)).getBoolean()) : String.valueOf(this.get(cat, key, this.defaults.get(key).getIntegerValue(), this.comments.get(key)).getInt());
            list.put(key, new Value(newVal, val.getType(), val.getShowInGui()));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("GlobalGameRules")) {
            this.syncConfigs();
        }
    }

    public static class Value
    implements Cloneable {
        private String stringValue;
        private int integerValue;
        private boolean booleanValue;
        private boolean showInGui;
        private ValueType type;

        public Value(String s, ValueType type) {
            this(s, type, true);
        }

        public Value(String s, ValueType type, boolean showInGui) {
            this.type = type;
            this.showInGui = showInGui;
            this.setValue(s);
        }

        public Value setValue(String s) {
            this.stringValue = s;
            this.booleanValue = Boolean.parseBoolean(s);
            this.integerValue = this.booleanValue ? 1 : 0;
            try {
                this.integerValue = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return this;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public boolean getShowInGui() {
            return this.showInGui;
        }

        public ValueType getType() {
            return this.type;
        }

        protected Value clone() throws CloneNotSupportedException {
            return (Value)super.clone();
        }
    }

    public static enum ValueType {
        BOOLEAN,
        INTEGER;

    }
}

