package se.gory_moon.chargers.compat;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.SlotItemHandler;

public class SlotBauble extends SlotItemHandler {

    private int baubleSlot;
    private EntityPlayer player;

    public SlotBauble(EntityPlayer player, IBaublesItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.player = player;
        this.baubleSlot = index;
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        return ((IBaublesItemHandler)getItemHandler()).isItemValidForSlot(baubleSlot, stack, player);
    }

    @Override
    public boolean func_82869_a(EntityPlayer player) {
        ItemStack stack = func_75211_c();
        if(stack.func_190926_b() && !stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null))
            return false;

        IBauble bauble = stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
        return bauble.canUnequip(stack, player);
    }

    @Override
    public ItemStack func_190901_a(EntityPlayer playerIn, ItemStack stack) {
        if (!func_75216_d() && stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null).onUnequipped(stack, playerIn);
        }
        super.func_190901_a(playerIn, stack);
        return stack;
    }

    @Override
    public void func_75215_d(ItemStack stack) {
        if (func_75216_d() && !ItemStack.func_77989_b(stack, func_75211_c()) &&
                func_75211_c().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            func_75211_c().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null).onUnequipped(func_75211_c(), player);
        }

        ItemStack oldStack = func_75211_c().func_77946_l();
        super.func_75215_d(stack);

        if (func_75216_d() && !ItemStack.func_77989_b(oldStack, func_75211_c()) &&
                func_75211_c().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            func_75211_c().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null).onEquipped(func_75211_c(), player);
        }
    }

    @Override
    public int func_75219_a() {
        return 1;
    }
}
