package se.gory_moon.chargers.blocks;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.blocks.BlockRegistry.ICustomItemBlock;
import se.gory_moon.chargers.blocks.BlockRegistry.ISubtypeItemBlockModelDefinition;
import se.gory_moon.chargers.items.ItemChargerBlock;
import se.gory_moon.chargers.proxy.CommonProxy;
import se.gory_moon.chargers.tile.TileEntityCharger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockCharger extends BlockEnergy implements ISubtypeItemBlockModelDefinition, ICustomItemBlock {

    public static PropertyEnum<Tier> TIERS = PropertyEnum.func_177709_a("tier", Tier.class);

    public BlockCharger() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        func_149647_a(CreativeTabs.field_78028_d);
        func_149711_c(5);
        func_149752_b(10);
        setHarvestLevel("pickaxe", 0);
    }

    @Override
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177229_b(TIERS).getColor();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K)
            return true;

        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCharger) {
            if (player.func_70093_af())
                return false;
            player.openGui(ChargersMod.INSTANCE, CommonProxy.GUI_CHARGER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            TileEntity aTile = world.func_175625_s(pos);
            if (aTile instanceof TileEntityCharger) {
                TileEntityCharger tile = (TileEntityCharger)aTile;
                for(int i = 0; i < tile.inventoryHandler.getSlots(); ++i) {
                    ItemStack stack = tile.inventoryHandler.getStackInSlot(i);
                    if (!stack.func_190926_b())
                        func_180635_a(world, pos, stack);
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(Side.CLIENT)
    public String func_149732_F() {
        return I18n.func_135052_a(this.func_149739_a() + "." + Tier.I.func_176610_l() + ".name");
    }

    @Nonnull
    @Override
    public ItemBlock getItemBlock() {
        return new ItemChargerBlock(this, this, stack -> Tier.byMetadata(stack.func_77960_j()).func_176610_l());
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Tier tier: Tier.values())
            items.add(new ItemStack(this, 1, tier.getMeta()));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return func_176201_c(state);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TIERS).getMeta();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(TIERS, Tier.byMetadata(meta));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return  new BlockStateContainer(this, TIERS);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCharger(state.func_177229_b(TIERS));
    }

    @Override
    public int getSubtypeNumber() {
        return 3;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + Tier.byMetadata(meta).func_176610_l();
    }

    public enum Tier implements IStringSerializable {
        I("tier_1", 0, MapColor.field_151670_w),
        II("tier_2", 1, MapColor.field_151647_F),
        III("tier_3", 2, MapColor.field_151679_y);

        private String unloc;
        private int meta;
        private MapColor color;

        private static final BlockCharger.Tier[] META_LOOKUP = new BlockCharger.Tier[values().length];

        Tier(String unloc, int meta, MapColor color) {
            this.unloc = unloc;
            this.meta = meta;
            this.color = color;
        }

        public int getMeta() {
            return meta;
        }

        public MapColor getColor() {
            return color;
        }

        @Override
        public String func_176610_l() {
            return unloc;
        }

        public int getStorage() {
            return this == BlockCharger.Tier.I ? Configs.chargers.tier1.storage: this == BlockCharger.Tier.II ? Configs.chargers.tier2.storage: Configs.chargers.tier3.storage;
        }

        public int getMaxIn() {
            return this == BlockCharger.Tier.I ? Configs.chargers.tier1.maxInput: this == BlockCharger.Tier.II ? Configs.chargers.tier2.maxInput: Configs.chargers.tier3.maxInput;
        }

        public int getMaxOut() {
            return this == BlockCharger.Tier.I ? Configs.chargers.tier1.maxOutput: this == BlockCharger.Tier.II ? Configs.chargers.tier2.maxOutput: Configs.chargers.tier3.maxOutput;
        }

        public static BlockCharger.Tier byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }

            return META_LOOKUP[meta];
        }

        static {
            for (BlockCharger.Tier tier : values()) {
                META_LOOKUP[tier.getMeta()] = tier;
            }
        }
    }
}
