/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.blocks;

import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

public class BlockWirelessCharger
extends Block {
    public static PropertyBool POWERED = PropertyBool.create((String)"powered");

    public BlockWirelessCharger() {
        super(Material.IRON, MapColor.GRAY);
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            return state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(((TileEntityWirelessCharger)tileEntity).canCharge()));
        }
        return state;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityWirelessCharger) {
            if (player.isSneaking()) {
                return false;
            }
            TileEntityWirelessCharger tile = (TileEntityWirelessCharger)tileEntity;
            boolean powered = ((TileEntityWirelessCharger)tileEntity).isPowered();
            ITextComponent status = new TextComponentTranslation("chat.chargers." + (powered ? "disabled" : "enabled"), new Object[0]).setStyle(new Style().setColor(powered ? TextFormatting.RED : TextFormatting.GREEN));
            NumberFormat format = NumberFormat.getInstance();
            player.sendStatusMessage((ITextComponent)new TextComponentTranslation("chat.chargers.wireless_charger.info", new Object[]{status, format.format(tile.storage.getEnergyStored()), format.format(tile.storage.getMaxEnergyStored())}), true);
        }
        return true;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.format((String)"tooltip.chargers.wireless_charger", (Object[])new Object[0]));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityWirelessCharger();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }
}

