/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.proxy;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import se.gory_moon.chargers.client.GuiCharger;
import se.gory_moon.chargers.items.ItemRegistry;
import se.gory_moon.chargers.proxy.CommonProxy;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class ClientProxy
extends CommonProxy {
    @Override
    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(new BlockPos(x, y, z));
        switch (ID) {
            case 1: {
                if (!(tile instanceof TileEntityCharger)) break;
                return new GuiCharger(player, (TileEntityCharger)tile);
            }
        }
        return null;
    }

    @Override
    public Map<Integer, ResourceLocation> getItemModelMap(Item item) {
        HashMap<Integer, ResourceLocation> map = new HashMap<Integer, ResourceLocation>();
        if (item instanceof ItemRegistry.IMultipleItemModelDefinition) {
            for (Map.Entry<Integer, ResourceLocation> model : ((ItemRegistry.IMultipleItemModelDefinition)item).getModels().entrySet()) {
                map.put(model.getKey(), (ResourceLocation)new ModelResourceLocation(model.getValue(), "inventory"));
            }
        } else {
            map.put(0, (ResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
        }
        return map;
    }

    @Override
    public void registerDefaultItemRenderer(Item item) {
        Map<Integer, ResourceLocation> map = this.getItemModelMap(item);
        for (Map.Entry<Integer, ResourceLocation> entry : map.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)entry.getKey(), (ModelResourceLocation)((ModelResourceLocation)entry.getValue()));
        }
    }
}

