package se.gory_moon.chargers.client;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.chargers.inventory.ContainerCharger;
import se.gory_moon.chargers.lib.ModInfo;
import se.gory_moon.chargers.tile.TileEntityCharger;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class GuiCharger extends GuiContainer {

    private TileEntityCharger charger;
    private static final ResourceLocation CHARGER_GUI_TEXTURE = new ResourceLocation(ModInfo.MODID + ":textures/gui/charger.png");

    public GuiCharger(InventoryPlayer inventory, TileEntityCharger tile) {
        super(new ContainerCharger(inventory, tile));
        this.charger = tile;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(CHARGER_GUI_TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        if (charger.storage.getEnergyStored() > 0) {
            int progress = (int)((float)charger.storage.getEnergyStored() / (float) charger.storage.getMaxEnergyStored() * 70);
            func_73729_b(field_147003_i + 58, field_147009_r + 78 - progress, 0, 236 - progress, 16, progress);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        func_191948_b(mouseX, mouseY);

        if (mouseX >= field_147003_i + 58 && mouseX <= field_147003_i + 74 && mouseY >= field_147009_r + 8 && mouseY <= field_147009_r + 78) {
            NumberFormat format = NumberFormat.getInstance();
            List<String> list = new ArrayList<>();
            list.add(I18n.func_135052_a("gui.chargers.energy", format.format(charger.storage.getEnergyStored()), format.format(charger.storage.getMaxEnergyStored())));
            list.add(I18n.func_135052_a("gui.chargers.max_in", format.format(charger.storage.getMaxInput())));
            list.add(I18n.func_135052_a("gui.chargers.max_out", format.format(charger.storage.getMaxOutput())));
            if (charger.getEnergyDiff() != 0) {
                list.add(I18n.func_135052_a("gui.chargers.io", (charger.getEnergyDiff() > 0 ? TextFormatting.GREEN + "+": TextFormatting.RED.toString()) + charger.getEnergyDiff()));
            }
            func_146283_a(list, mouseX, mouseY);
        }
    }
}
